/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.persistent.AbstractPageFile;
import elki.persistent.Page;
import elki.persistent.PageHeader;
import elki.utilities.datastructures.arraylike.IntegerArray;

public abstract class AbstractStoringPageFile<P extends Page>
extends AbstractPageFile<P> {
    protected IntegerArray emptyPages = new IntegerArray();
    protected int nextPageID = 0;
    protected int pageSize;

    protected AbstractStoringPageFile(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int setPageID(P page) {
        int pageID = page.getPageID();
        if (pageID == -1) {
            pageID = this.getNextEmptyPageID();
            if (pageID == -1) {
                pageID = this.nextPageID++;
            }
            page.setPageID(pageID);
        } else if (pageID >= this.nextPageID) {
            for (int i = this.nextPageID; i < pageID; ++i) {
                this.emptyPages.add(i);
            }
            this.nextPageID = pageID + 1;
        }
        return pageID;
    }

    @Override
    public void deletePage(int pageID) {
        this.emptyPages.add(pageID);
    }

    private int getNextEmptyPageID() {
        return this.emptyPages.isEmpty() ? -1 : this.emptyPages.get(--this.emptyPages.size);
    }

    @Override
    public int getNextPageID() {
        return this.nextPageID;
    }

    @Override
    public void setNextPageID(int nextPageID) {
        this.nextPageID = nextPageID;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean initialize(PageHeader header) {
        this.pageSize = header.getPageSize();
        return false;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        if (this.getLogger().isStatistics()) {
            this.getLogger().statistics((Statistic)new LongStatistic(this.getClass().getName() + ".numpages", (long)(this.nextPageID - this.emptyPages.size())));
        }
    }
}

