/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.logging.Logging;
import elki.persistent.AbstractStoringPageFile;
import elki.persistent.Page;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class MemoryPageFile<P extends Page>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(MemoryPageFile.class);
    private final Int2ObjectOpenHashMap<P> file = new Int2ObjectOpenHashMap();

    public MemoryPageFile(int pageSize) {
        super(pageSize);
    }

    @Override
    public synchronized P readPage(int pageID) {
        this.countRead();
        return (P)((Page)this.file.get(pageID));
    }

    @Override
    protected void writePage(int pageID, P page) {
        this.countWrite();
        this.file.put(pageID, page);
        page.setDirty(false);
    }

    @Override
    public synchronized void deletePage(int pageID) {
        super.deletePage(pageID);
        this.countWrite();
        this.file.remove(pageID);
    }

    @Override
    public void clear() {
        this.file.clear();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

