/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class OnDiskArray
implements AutoCloseable {
    private static final long serialVersionUID = 7586497243452875056L;
    protected int magic;
    private int headersize;
    private int recordsize;
    private int numrecs;
    private Path filename;
    private final FileChannel file;
    private FileLock lock = null;
    private boolean writable;
    private MappedByteBuffer map;
    private static final int INTERNAL_HEADER_SIZE = 16;
    private static final int HEADER_POS_SIZE = 12;

    public OnDiskArray(Path filename, int magicseed, int extraheadersize, int recordsize, int initialsize) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, magicseed);
        this.headersize = extraheadersize + 16;
        this.recordsize = recordsize;
        this.filename = filename;
        this.writable = true;
        if (Files.exists(filename, new LinkOption[0]) && Files.size(filename) != 0L) {
            throw new IOException("File already exists: " + filename);
        }
        this.file = FileChannel.open(filename, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        this.lock = this.file.lock();
        ByteBuffer bbuf = ByteBuffer.allocateDirect(16);
        bbuf.putInt(this.magic).putInt(this.headersize).putInt(this.recordsize).putInt(initialsize).flip();
        this.file.write(bbuf, 0L);
        this.resizeFile(initialsize);
        this.mapArray();
    }

    public OnDiskArray(Path filename, int magicseed, int extraheadersize, int recordsize, boolean writable) throws IOException {
        OpenOption[] openOptionArray;
        this.magic = OnDiskArray.mixMagic(1165828400, magicseed);
        this.headersize = extraheadersize + 16;
        this.recordsize = recordsize;
        this.filename = filename;
        this.writable = writable;
        if (writable) {
            OpenOption[] openOptionArray2 = new OpenOption[2];
            openOptionArray2[0] = StandardOpenOption.READ;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.WRITE;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[1];
            openOptionArray = openOptionArray3;
            openOptionArray3[0] = StandardOpenOption.READ;
        }
        this.file = FileChannel.open(filename, openOptionArray);
        this.lock = writable ? this.file.lock() : null;
        this.validateHeader(true);
        this.mapArray();
    }

    public OnDiskArray(Path filename, int magicseed, int extraheadersize, boolean writable) throws IOException {
        OpenOption[] openOptionArray;
        this.magic = OnDiskArray.mixMagic(1165828400, magicseed);
        this.headersize = extraheadersize + 16;
        this.filename = filename;
        this.writable = writable;
        if (writable) {
            OpenOption[] openOptionArray2 = new OpenOption[2];
            openOptionArray2[0] = StandardOpenOption.READ;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.WRITE;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[1];
            openOptionArray = openOptionArray3;
            openOptionArray3[0] = StandardOpenOption.READ;
        }
        this.file = FileChannel.open(filename, openOptionArray);
        this.lock = writable ? this.file.lock() : null;
        this.validateHeader(false);
        this.mapArray();
    }

    private synchronized void mapArray() throws IOException {
        if (this.map != null) {
            this.map.force();
            this.map = null;
        }
        FileChannel.MapMode mode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
        long size = (long)this.recordsize * (long)this.numrecs;
        if (size > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("OnDiskArray currently has a maximum size of: 2147483647 (see Java FileChannel#map).");
        }
        this.map = this.file.map(mode, this.headersize, size);
    }

    private void validateHeader(boolean validateRecordSize) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocateDirect(16);
        if (this.file.read(bbuf, 0L) != 16) {
            throw new IOException("Incomplete read validating the header");
        }
        bbuf.flip();
        int readmagic = bbuf.getInt();
        if (readmagic != this.magic) {
            this.file.close();
            throw new IOException("Magic in LinearDiskCache does not match: " + readmagic + " instead of " + this.magic);
        }
        if (bbuf.getInt() != this.headersize) {
            this.file.close();
            throw new IOException("Header size in LinearDiskCache does not match.");
        }
        if (validateRecordSize) {
            if (bbuf.getInt() != this.recordsize) {
                this.file.close();
                throw new IOException("Recordsize in LinearDiskCache does not match.");
            }
        } else {
            this.recordsize = bbuf.getInt();
        }
        this.numrecs = bbuf.getInt();
        if (this.numrecs < 0 || this.file.size() != this.indexToFileposition(this.numrecs)) {
            throw new IOException("File size and number of records do not agree.");
        }
    }

    public static final int mixMagic(int magic1, int magic2) {
        long prime = 2654435761L;
        return (int)(2654435761L * (2654435761L + (long)magic1) + (long)magic2);
    }

    private long indexToFileposition(long index) {
        return (long)this.headersize + index * (long)this.recordsize;
    }

    public synchronized void resizeFile(int newsize) throws IOException {
        if (!this.writable) {
            throw new IOException("File is not writeable!");
        }
        this.numrecs = newsize;
        ByteBuffer bbuf = ByteBuffer.allocateDirect(4);
        bbuf.putInt(this.numrecs).flip();
        this.file.write(bbuf, 12L);
        this.file.truncate(this.indexToFileposition(this.numrecs));
        this.mapArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteBuffer getRecordBuffer(int index) throws IOException {
        if (index < 0 || index >= this.numrecs) {
            throw new IOException("Access beyond end of file.");
        }
        MappedByteBuffer mappedByteBuffer = this.map;
        synchronized (mappedByteBuffer) {
            this.map.limit(this.recordsize * (index + 1));
            this.map.position(this.recordsize * index);
            return this.map.slice();
        }
    }

    protected int getExtraHeaderSize() {
        return this.headersize - 16;
    }

    public synchronized ByteBuffer getExtraHeader() throws IOException {
        int size = this.headersize - 16;
        FileChannel.MapMode mode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
        return this.file.map(mode, 16L, size);
    }

    protected int getRecordsize() {
        return this.recordsize;
    }

    public Path getFilename() {
        return this.filename;
    }

    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public synchronized void close() throws IOException {
        this.writable = false;
        if (this.map != null) {
            this.map.force();
            this.map = null;
        }
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
        this.file.close();
    }

    public int getNumRecords() {
        return this.numrecs;
    }

    public void ensureSize(int size) throws IOException {
        if (size > this.getNumRecords()) {
            this.resizeFile(size);
        }
    }
}

