/*
 * Decompiled with CFR 0.152.
 */
package elki.application.cache;

import elki.application.AbstractApplication;
import elki.database.Database;
import elki.database.StaticArrayDatabase;
import elki.database.ids.DBIDIter;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.ByteArrayUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class CacheDoubleDistanceKNNLists<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheDoubleDistanceKNNLists.class);
    private Database database;
    private Distance<? super O> distance;
    private int k;
    private Path out;
    public static final int KNN_CACHE_MAGIC = -893108964;

    public CacheDoubleDistanceKNNLists(Database database, Distance<? super O> distance, int k, Path out) {
        this.database = database;
        this.distance = distance;
        this.k = k;
        this.out = out;
    }

    public void run() {
        this.database.initialize();
        Relation relation = this.database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        KNNSearcher knnQ = new QueryBuilder(relation, this.distance).noCache().kNNByDBID(this.k);
        try (FileChannel channel = FileChannel.open(this.out, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             FileLock lock = channel.lock();){
            int bufsize = this.k * 12 * 2 + 10;
            ByteBuffer buffer = ByteBuffer.allocateDirect(bufsize);
            buffer.putInt(-893108964).flip();
            channel.write(buffer);
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing kNN", relation.size(), LOG) : null;
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                KNNList nn = knnQ.getKNN((Object)it, this.k);
                int nnsize = nn.size();
                if (nnsize * 12 + 10 > bufsize) {
                    while (nnsize * 12 + 10 > bufsize) {
                        bufsize <<= 1;
                    }
                    buffer = ByteBuffer.allocateDirect(bufsize);
                }
                buffer.clear();
                ByteArrayUtil.writeUnsignedVarint((ByteBuffer)buffer, (int)it.internalGetIndex());
                ByteArrayUtil.writeUnsignedVarint((ByteBuffer)buffer, (int)nnsize);
                int c = 0;
                DoubleDBIDListIter ni = nn.iter();
                while (ni.valid()) {
                    ByteArrayUtil.writeUnsignedVarint((ByteBuffer)buffer, (int)ni.internalGetIndex());
                    buffer.putDouble(ni.doubleValue());
                    ni.advance();
                    ++c;
                }
                if (c != nn.size()) {
                    throw new AbortException("Sizes did not agree. Cache is invalid.");
                }
                buffer.flip();
                channel.write(buffer);
                LOG.incrementProcessed((AbstractProgress)prog);
                it.advance();
            }
            LOG.ensureCompleted(prog);
            lock.release();
        }
        catch (IOException e) {
            LOG.exception((Throwable)e);
        }
    }

    public static void main(String[] args) {
        CacheDoubleDistanceKNNLists.runCLIApplication(CacheDoubleDistanceKNNLists.class, (String[])args);
    }

    public static class Par<O>
    extends AbstractApplication.Par {
        public static final OptionID CACHE_ID = new OptionID("loader.diskcache", "File name of the disk cache to create.");
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        public static final OptionID K_ID = new OptionID("loader.k", "Number of nearest neighbors to precompute.");
        private Database database = null;
        private Distance<? super O> distance = null;
        private int k;
        private Path out = null;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_ID, Database.class, StaticArrayDatabase.class).grab(config, x -> {
                this.database = x;
            });
            new ObjectParameter(DISTANCE_ID, Distance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new FileParameter(CACHE_ID, FileParameter.FileType.OUTPUT_FILE).grab(config, x -> {
                this.out = Paths.get(x);
            });
        }

        public CacheDoubleDistanceKNNLists<O> make() {
            return new CacheDoubleDistanceKNNLists<O>(this.database, this.distance, this.k, this.out);
        }
    }
}

