/*
 * Decompiled with CFR 0.152.
 */
package elki.application.cache;

import elki.application.AbstractApplication;
import elki.database.Database;
import elki.database.StaticArrayDatabase;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.ByteArrayUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class CacheDoubleDistanceRangeQueries<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheDoubleDistanceRangeQueries.class);
    private Database database;
    private Distance<? super O> distance;
    private double radius;
    private Path out;
    public static final int RANGE_CACHE_MAGIC = -893111501;

    public CacheDoubleDistanceRangeQueries(Database database, Distance<? super O> distance, double radius, Path out) {
        this.database = database;
        this.distance = distance;
        this.radius = radius;
        this.out = out;
    }

    public void run() {
        this.database.initialize();
        Relation relation = this.database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        RangeSearcher rangeQ = new QueryBuilder(relation, this.distance).rangeByDBID();
        LOG.verbose((CharSequence)("Performing range queries with radius " + this.radius));
        try (FileChannel channel = FileChannel.open(this.out, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             FileLock lock = channel.lock();){
            int bufsize = 2410;
            ByteBuffer buffer = ByteBuffer.allocateDirect(bufsize);
            buffer.putInt(-893111501).putDouble(this.radius).flip();
            channel.write(buffer);
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing range queries", relation.size(), LOG) : null;
            ModifiableDoubleDBIDList nn = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter ni = nn.iter();
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                rangeQ.getRange((Object)it, this.radius, nn.clear()).sort();
                int nnsize = nn.size();
                if (nnsize * 12 + 10 > bufsize) {
                    while (nnsize * 12 + 10 > bufsize) {
                        bufsize <<= 1;
                    }
                    LOG.verbose((CharSequence)("Resizing buffer to " + bufsize + " to store " + nnsize + " results:"));
                    buffer = ByteBuffer.allocateDirect(bufsize);
                }
                buffer.clear();
                ByteArrayUtil.writeUnsignedVarint((ByteBuffer)buffer, (int)it.internalGetIndex());
                ByteArrayUtil.writeUnsignedVarint((ByteBuffer)buffer, (int)nnsize);
                int c = 0;
                ni.seek(0);
                while (ni.valid()) {
                    ByteArrayUtil.writeUnsignedVarint((ByteBuffer)buffer, (int)ni.internalGetIndex());
                    buffer.putDouble(ni.doubleValue());
                    ni.advance();
                    ++c;
                }
                if (c != nn.size()) {
                    throw new AbortException("Sizes did not agree. Cache is invalid.");
                }
                buffer.flip();
                channel.write(buffer);
                LOG.incrementProcessed((AbstractProgress)prog);
                it.advance();
            }
            LOG.ensureCompleted(prog);
            lock.release();
        }
        catch (IOException e) {
            LOG.exception((Throwable)e);
        }
    }

    public static void main(String[] args) {
        CacheDoubleDistanceRangeQueries.runCLIApplication(CacheDoubleDistanceRangeQueries.class, (String[])args);
    }

    public static class Par<O>
    extends AbstractApplication.Par {
        public static final OptionID CACHE_ID = new OptionID("loader.diskcache", "File name of the disk cache to create.");
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        public static final OptionID RADIUS_ID = new OptionID("loader.radius", "Query radius for precomputation.");
        private Database database = null;
        private Distance<? super O> distance = null;
        private double radius;
        private Path out = null;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_ID, Database.class, StaticArrayDatabase.class).grab(config, x -> {
                this.database = x;
            });
            new ObjectParameter(DISTANCE_ID, Distance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(RADIUS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.radius = x;
            });
            new FileParameter(CACHE_ID, FileParameter.FileType.OUTPUT_FILE).grab(config, x -> {
                this.out = Paths.get(x);
            });
        }

        public CacheDoubleDistanceRangeQueries<O> make() {
            return new CacheDoubleDistanceRangeQueries<O>(this.database, this.distance, this.radius, this.out);
        }
    }
}

