/*
 * Decompiled with CFR 0.152.
 */
package elki.application.cache;

import elki.application.AbstractApplication;
import elki.application.cache.CacheDoubleDistanceInOnDiskMatrix;
import elki.database.Database;
import elki.database.StaticArrayDatabase;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.persistent.OnDiskUpperTriangleMatrix;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CacheFloatDistanceInOnDiskMatrix<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheFloatDistanceInOnDiskMatrix.class);
    private static final boolean debugExtraCheckSymmetry = false;
    private Database database;
    private Distance<? super O> distance;
    private Path out;

    public CacheFloatDistanceInOnDiskMatrix(Database database, Distance<? super O> distance, Path out) {
        this.database = database;
        this.distance = distance;
        this.out = out;
    }

    public void run() {
        this.database.initialize();
        Relation relation = this.database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery distanceQuery = new QueryBuilder(relation, this.distance).distanceQuery();
        DBIDRange ids = DBIDUtil.assertRange((DBIDs)relation.getDBIDs());
        int size = ids.size();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing distances", (int)((long)(size + 1) * (long)size >>> 1), LOG) : null;
        try (OnDiskUpperTriangleMatrix matrix = new OnDiskUpperTriangleMatrix(this.out, 23423411, 0, 4, size);){
            DBIDArrayIter id1 = ids.iter();
            DBIDArrayIter id2 = ids.iter();
            while (id1.valid()) {
                id2.seek(id1.getOffset());
                while (id2.valid()) {
                    float d = (float)distanceQuery.distance((DBIDRef)id1, (DBIDRef)id2);
                    try {
                        matrix.getRecordBuffer(id1.getOffset(), id2.getOffset()).putFloat(d);
                    }
                    catch (IOException e) {
                        throw new AbortException("Error writing distance record " + DBIDUtil.toString((DBIDRef)id1) + "," + DBIDUtil.toString((DBIDRef)id2) + " to matrix.", (Throwable)e);
                    }
                    id2.advance();
                }
                if (prog != null) {
                    prog.setProcessed(prog.getProcessed() + (size - id1.getOffset()), LOG);
                }
                id1.advance();
            }
        }
        catch (IOException e) {
            throw new AbortException("Error precomputing distance matrix.", (Throwable)e);
        }
        LOG.ensureCompleted(prog);
    }

    public static void main(String[] args) {
        CacheFloatDistanceInOnDiskMatrix.runCLIApplication(CacheFloatDistanceInOnDiskMatrix.class, (String[])args);
    }

    public static class Par<O>
    extends AbstractApplication.Par {
        private Database database = null;
        private Distance<? super O> distance = null;
        private Path out = null;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_ID, Database.class, StaticArrayDatabase.class).grab(config, x -> {
                this.database = x;
            });
            new ObjectParameter(CacheDoubleDistanceInOnDiskMatrix.Par.DISTANCE_ID, Distance.class).grab(config, x -> {
                this.distance = x;
            });
            new FileParameter(CacheDoubleDistanceInOnDiskMatrix.Par.CACHE_ID, FileParameter.FileType.OUTPUT_FILE).grab(config, x -> {
                this.out = Paths.get(x);
            });
        }

        public CacheFloatDistanceInOnDiskMatrix<O> make() {
            return new CacheFloatDistanceInOnDiskMatrix<O>(this.database, this.distance, this.out);
        }
    }
}

