/*
 * Decompiled with CFR 0.152.
 */
package elki.application.cache;

import elki.application.AbstractApplication;
import elki.database.Database;
import elki.database.StaticArrayDatabase;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;

public class PrecomputeDistancesAsciiApplication<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(PrecomputeDistancesAsciiApplication.class);
    public static final String GZIP_POSTFIX = ".gz";
    private boolean debugExtraCheckSymmetry = false;
    private Database database;
    private Distance<? super O> distance;
    private Path out;

    public PrecomputeDistancesAsciiApplication(Database database, Distance<? super O> distance, Path out) {
        this.database = database;
        this.distance = distance;
        this.out = out;
    }

    public void run() {
        this.database.initialize();
        Relation relation = this.database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery distanceQuery = new QueryBuilder(relation, this.distance).distanceQuery();
        DBIDRange ids = DBIDUtil.assertRange((DBIDs)relation.getDBIDs());
        int size = ids.size();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing distances", (int)((long)(size - 1) * (long)size >>> 1), LOG) : null;
        try (PrintStream fout = PrecomputeDistancesAsciiApplication.openStream(this.out);){
            DBIDArrayIter id1 = ids.iter();
            DBIDArrayIter id2 = ids.iter();
            while (id1.valid()) {
                String idstr1 = Integer.toString(id1.getOffset());
                if (this.debugExtraCheckSymmetry && distanceQuery.distance((DBIDRef)id1, (DBIDRef)id1) != 0.0) {
                    LOG.warning((CharSequence)"Distance function doesn't satisfy d(0,0) = 0.");
                }
                id2.seek(id1.getOffset() + 1);
                while (id2.valid()) {
                    double d2;
                    double d = distanceQuery.distance((DBIDRef)id1, (DBIDRef)id2);
                    if (this.debugExtraCheckSymmetry && Math.abs(d - (d2 = distanceQuery.distance((DBIDRef)id2, (DBIDRef)id1))) > 1.0E-7) {
                        LOG.warning((CharSequence)"Distance function doesn't appear to be symmetric!");
                    }
                    fout.append(idstr1).append('\t').append(Integer.toString(id2.getOffset())).append('\t').append(Double.toString(d)).append('\n');
                    id2.advance();
                }
                if (prog != null) {
                    prog.setProcessed(prog.getProcessed() + (size - id1.getOffset() - 1), LOG);
                }
                id1.advance();
            }
        }
        catch (IOException e) {
            throw new AbortException("Could not write to output file.", (Throwable)e);
        }
        LOG.ensureCompleted(prog);
    }

    private static PrintStream openStream(Path out) throws IOException {
        OutputStream os = Files.newOutputStream(out, new OpenOption[0]);
        return new PrintStream(out.getFileName().endsWith(GZIP_POSTFIX) ? new GZIPOutputStream(os) : os);
    }

    public static void main(String[] args) {
        PrecomputeDistancesAsciiApplication.runCLIApplication(PrecomputeDistancesAsciiApplication.class, (String[])args);
    }

    public static class Par<O>
    extends AbstractApplication.Par {
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        private Database database = null;
        private Distance<? super O> distance = null;
        private Path out = null;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_ID, Database.class, StaticArrayDatabase.class).grab(config, x -> {
                this.database = x;
            });
            new ObjectParameter(DISTANCE_ID, Distance.class).grab(config, x -> {
                this.distance = x;
            });
            this.out = this.getParameterOutputFile(config);
        }

        public PrecomputeDistancesAsciiApplication<O> make() {
            return new PrecomputeDistancesAsciiApplication<O>(this.database, this.distance, this.out);
        }
    }
}

