/*
 * Decompiled with CFR 0.152.
 */
package elki.distance.external;

import elki.datasource.parser.CSVReaderFormat;
import elki.distance.external.DistanceParser;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.utilities.io.TokenizedReader;
import elki.utilities.io.Tokenizer;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.IOException;
import java.io.InputStream;

public class AsciiDistanceParser
implements DistanceParser {
    private static final Logging LOG = Logging.getLogger(AsciiDistanceParser.class);
    protected TokenizedReader reader;
    protected Tokenizer tokenizer;

    public AsciiDistanceParser(CSVReaderFormat format) {
        this.reader = format.makeReader();
        this.tokenizer = this.reader.getTokenizer();
    }

    @Override
    public void parse(InputStream in, DistanceParser.DistanceCacheWriter cache) {
        this.reader.reset(in);
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("Parsing distance matrix", LOG) : null;
        try {
            while (this.reader.nextLineExceptComments()) {
                int id2;
                int id1;
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    id1 = this.tokenizer.getIntBase10();
                    this.tokenizer.advance();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ": id1 is not an integer!");
                }
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    id2 = this.tokenizer.getIntBase10();
                    this.tokenizer.advance();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ": id2 is not an integer!");
                }
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    cache.put(id1, id2, this.tokenizer.getDouble());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ":" + e.getMessage(), e);
                }
                this.tokenizer.advance();
                if (this.tokenizer.valid()) {
                    throw new IllegalArgumentException("More than three values in line " + this.reader.getLineNumber());
                }
                LOG.incrementProcessed((AbstractProgress)prog);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
        LOG.setCompleted(prog);
    }

    public static class Par
    implements Parameterizer {
        protected CSVReaderFormat format;

        public void configure(Parameterization config) {
            this.format = (CSVReaderFormat)config.tryInstantiate(CSVReaderFormat.class);
        }

        public AsciiDistanceParser make() {
            return new AsciiDistanceParser(this.format);
        }
    }
}

