/*
 * Decompiled with CFR 0.152.
 */
package elki.distance.external;

import elki.database.ids.DBIDRange;
import elki.distance.AbstractDBIDRangeDistance;
import elki.distance.external.DiskCacheBasedDoubleDistance;
import elki.logging.Logging;
import elki.persistent.OnDiskUpperTriangleMatrix;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.Parameter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DiskCacheBasedFloatDistance
extends AbstractDBIDRangeDistance {
    private static final Logging LOG = Logging.getLogger(DiskCacheBasedFloatDistance.class);
    public static final int FLOAT_CACHE_MAGIC = 23423411;
    private OnDiskUpperTriangleMatrix cache;

    public DiskCacheBasedFloatDistance(OnDiskUpperTriangleMatrix cache) {
        this.cache = cache;
    }

    public DiskCacheBasedFloatDistance(Path matrixfile) throws IOException {
        this.cache = new OnDiskUpperTriangleMatrix(matrixfile, 23423411, 0, 4, false);
    }

    public double distance(int i1, int i2) {
        try {
            return this.cache.getRecordBuffer(i1, i2).getFloat();
        }
        catch (IOException e) {
            throw new RuntimeException("Read error when loading distance " + i1 + "," + i2 + " from cache file.", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DiskCacheBasedFloatDistance other = (DiskCacheBasedFloatDistance)((Object)obj);
        return this.cache.equals(other.cache);
    }

    public void checkRange(DBIDRange range) {
        if (this.cache.getMatrixSize() < range.size()) {
            LOG.warning((CharSequence)("Distance matrix has size " + this.cache.getMatrixSize() + " but range has size: " + range.size()));
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MATRIX_ID = DiskCacheBasedDoubleDistance.Par.MATRIX_ID;
        protected OnDiskUpperTriangleMatrix cache = null;

        public void configure(Parameterization config) {
            FileParameter param = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            param.grab(config, matrixfile -> {
                try {
                    this.cache = new OnDiskUpperTriangleMatrix(Paths.get(matrixfile), 23423411, 0, 4, false);
                }
                catch (IOException e) {
                    config.reportError((ParameterException)new WrongParameterValueException((Parameter)param, matrixfile.toString(), e.getMessage(), (Throwable)e));
                }
            });
        }

        public DiskCacheBasedFloatDistance make() {
            return new DiskCacheBasedFloatDistance(this.cache);
        }
    }
}

