/*
 * Decompiled with CFR 0.152.
 */
package elki.distance.external;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRange;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.AbstractDBIDRangeDistance;
import elki.distance.external.AsciiDistanceParser;
import elki.distance.external.DistanceParser;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.OpenOption;

public class FileBasedSparseDoubleDistance
extends AbstractDBIDRangeDistance {
    private static final Logging LOG = Logging.getLogger(FileBasedSparseDoubleDistance.class);
    private Long2DoubleOpenHashMap cache;
    private DistanceParser parser;
    private URI matrixfile;
    private int min;
    private int max;
    protected double defaultDistance = Double.POSITIVE_INFINITY;

    public FileBasedSparseDoubleDistance(DistanceParser parser, URI matrixfile, double defaultDistance) {
        this.parser = parser;
        this.matrixfile = matrixfile;
        this.defaultDistance = defaultDistance;
    }

    public <O extends DBID> DistanceQuery<O> instantiate(Relation<O> relation) {
        if (this.cache == null) {
            int size = relation.size();
            try {
                this.loadCache(size, new BufferedInputStream(FileUtil.open((URI)this.matrixfile, (OpenOption[])new OpenOption[0])));
            }
            catch (IOException e) {
                throw new AbortException("Could not load external distance file: " + this.matrixfile.toString(), (Throwable)e);
            }
        }
        return super.instantiate(relation);
    }

    public double distance(int i1, int i2) {
        return i1 == i2 ? 0.0 : this.cache.get(FileBasedSparseDoubleDistance.makeKey(i1 + this.min, i2 + this.min));
    }

    protected void loadCache(int size, InputStream in) {
        this.cache = new Long2DoubleOpenHashMap(size * 20);
        this.cache.defaultReturnValue(Double.POSITIVE_INFINITY);
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.parser.parse(in, (id1, id2, distance) -> {
            if (id1 < id2) {
                this.min = id1 < this.min ? id1 : this.min;
                this.max = id2 > this.max ? id2 : this.max;
            } else {
                this.min = id2 < this.min ? id2 : this.min;
                this.max = id1 > this.max ? id1 : this.max;
            }
            this.cache.put(FileBasedSparseDoubleDistance.makeKey(id1, id2), distance);
        });
        if (this.min != 0 && LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Distance matrix is supposed to be 0-indexed. Choosing offset " + this.min + " to compensate."));
        }
        if (this.max + 1 - this.min != size) {
            LOG.warning((CharSequence)"ID range is not consistent with relation size.");
        }
    }

    protected static final long makeKey(int i1, int i2) {
        return i1 < i2 ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
    }

    public void checkRange(DBIDRange range) {
        int size = this.max + 1 - this.min;
        if (size < range.size()) {
            LOG.warning((CharSequence)("Distance matrix has size " + size + " but range has size: " + range.size()));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FileBasedSparseDoubleDistance other = (FileBasedSparseDoubleDistance)((Object)obj);
        return this.cache.equals((Object)other.cache);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MATRIX_ID = new OptionID("distance.matrix", "The name of the file containing the distance matrix.");
        public static final OptionID PARSER_ID = new OptionID("distance.parser", "Parser used to load the distance matrix.");
        public static final OptionID DEFAULTDIST_ID = new OptionID("distance.default", "Default distance to use for undefined values.");
        protected URI matrixfile = null;
        protected DistanceParser parser = null;
        protected double defaultDistance = Double.POSITIVE_INFINITY;

        public void configure(Parameterization config) {
            new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.matrixfile = x;
            });
            new ObjectParameter(PARSER_ID, DistanceParser.class, AsciiDistanceParser.class).grab(config, x -> {
                this.parser = x;
            });
            new DoubleParameter(DEFAULTDIST_ID, Double.POSITIVE_INFINITY).grab(config, x -> {
                this.defaultDistance = x;
            });
        }

        public FileBasedSparseDoubleDistance make() {
            return new FileBasedSparseDoubleDistance(this.parser, this.matrixfile, this.defaultDistance);
        }
    }
}

