/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.ByteArrayUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class CachedDoubleDistanceKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private Path filename;
    private static final Logging LOG = Logging.getLogger(CachedDoubleDistanceKNNPreprocessor.class);

    public CachedDoubleDistanceKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k, Path file) {
        super(relation, distance, k);
        this.filename = file;
    }

    protected void preprocess() {
        this.createStorage();
        try (FileChannel channel = FileChannel.open(this.filename, StandardOpenOption.READ);){
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            int header = buffer.getInt();
            if (header != -893108964) {
                throw new AbortException("Cache magic number does not match.");
            }
            DBIDIter iter = this.relation.iterDBIDs();
            while (iter.valid()) {
                int dbid = ByteArrayUtil.readUnsignedVarint((ByteBuffer)buffer);
                int nnsize = ByteArrayUtil.readUnsignedVarint((ByteBuffer)buffer);
                if (nnsize < this.k) {
                    throw new AbortException("kNN cache contains fewer than k objects!");
                }
                KNNHeap knn = DBIDUtil.newHeap((int)this.k);
                for (int i = 0; i < nnsize; ++i) {
                    int nid = ByteArrayUtil.readUnsignedVarint((ByteBuffer)buffer);
                    double dist = buffer.getDouble();
                    knn.insert(dist, (DBIDRef)DBIDUtil.importInteger((int)nid));
                }
                this.storage.put((DBIDRef)DBIDUtil.importInteger((int)dbid), (Object)knn.toKNNList());
                iter.advance();
            }
            if (buffer.hasRemaining()) {
                LOG.warning((CharSequence)("kNN cache has " + buffer.remaining() + " bytes remaining!"));
            }
        }
        catch (IOException e) {
            throw new AbortException("I/O error in loading kNN cache: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private Path filename;

        public Factory(int k, Distance<? super O> distance, Path filename) {
            super(k, distance);
            this.filename = filename;
        }

        public CachedDoubleDistanceKNNPreprocessor<O> instantiate(Relation<O> relation) {
            CachedDoubleDistanceKNNPreprocessor<O> instance = new CachedDoubleDistanceKNNPreprocessor<O>(relation, this.distance, this.k, this.filename);
            return instance;
        }

        public static class Par<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<O> {
            public static final OptionID CACHE_ID = new OptionID("external.knnfile", "Filename with the precomputed k nearest neighbors.");
            private Path filename;

            public void configure(Parameterization config) {
                super.configure(config);
                new FileParameter(CACHE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                    this.filename = Paths.get(x);
                });
            }

            public Factory<O> make() {
                return new Factory(this.k, this.distance, this.filename);
            }
        }
    }
}

