/*
 * Decompiled with CFR 0.152.
 */
package elki;

import elki.application.KDDCLIApplication;
import elki.database.Database;
import elki.result.Metadata;
import elki.result.SettingsResult;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameterization.TrackParameters;
import elki.utilities.optionhandling.parameterization.TrackedParameter;
import elki.workflow.AlgorithmStep;
import elki.workflow.EvaluationStep;
import elki.workflow.InputStep;
import elki.workflow.OutputStep;
import java.util.Collection;

public class KDDTask {
    private Collection<TrackedParameter> settings;
    private InputStep inputStep;
    private AlgorithmStep algorithmStep;
    private EvaluationStep evaluationStep;
    private OutputStep outputStep;

    public KDDTask(InputStep inputStep, AlgorithmStep algorithmStep, EvaluationStep evaluationStep, OutputStep outputStep, Collection<TrackedParameter> settings) {
        this.inputStep = inputStep;
        this.algorithmStep = algorithmStep;
        this.evaluationStep = evaluationStep;
        this.outputStep = outputStep;
        this.settings = settings;
    }

    public void run() {
        Database db = this.inputStep.getDatabase();
        this.algorithmStep.runAlgorithms(db);
        Metadata.hierarchyOf((Object)db).addChild((Object)new SettingsResult(this.settings));
        this.evaluationStep.runEvaluators(db);
        this.outputStep.runResultHandlers(db);
    }

    public static void main(String[] args) {
        KDDCLIApplication.runCLIApplication(KDDCLIApplication.class, (String[])args);
    }

    public static class Par
    implements Parameterizer {
        InputStep inputStep = null;
        AlgorithmStep algorithmStep = null;
        EvaluationStep evaluationStep = null;
        Collection<TrackedParameter> settings = null;
        OutputStep outputStep = null;

        public void configure(Parameterization config) {
            TrackParameters track = new TrackParameters(config);
            this.inputStep = (InputStep)track.tryInstantiate(InputStep.class);
            this.algorithmStep = (AlgorithmStep)track.tryInstantiate(AlgorithmStep.class);
            this.evaluationStep = (EvaluationStep)track.tryInstantiate(EvaluationStep.class);
            this.settings = track.getAllParameters();
            this.outputStep = (OutputStep)config.tryInstantiate(OutputStep.class);
        }

        public KDDTask make() {
            return new KDDTask(this.inputStep, this.algorithmStep, this.evaluationStep, this.outputStep, this.settings);
        }
    }
}

