/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.geometry.XYCurve;
import elki.result.Metadata;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Arrays;

@Title(value="KNN-Distance-Order")
@Description(value="Assesses the knn distances for a specified k and orders them.")
@References(value={@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96"), @Reference(authors="Erich Schubert, J\u00f6rg Sander, Martin Ester, Hans-Peter Kriegel, Xiaowei Xu", title="DBSCAN Revisited, Revisited: Why and How You Should (Still) Use DBSCAN", booktitle="ACM Trans. Database Systems (TODS)", url="https://doi.org/10.1145/3068335", bibkey="DBLP:journals/tods/SchubertSEKX17")})
public class KNNDistancesSampler<O>
implements Algorithm {
    private static final Logging LOG = Logging.getLogger(KNNDistancesSampler.class);
    protected Distance<? super O> distance;
    protected int k;
    protected double sample;
    protected RandomFactory rnd;

    public KNNDistancesSampler(Distance<? super O> distance, int k, double sample, RandomFactory rnd) {
        this.distance = distance;
        this.k = k;
        this.sample = sample;
        this.rnd = rnd;
    }

    public KNNDistanceOrderResult run(Relation<O> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.k + 1);
        int size = (int)(this.sample <= 1.0 ? Math.ceil((double)relation.size() * this.sample) : this.sample);
        ModifiableDBIDs sample = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (int)size, (RandomFactory)this.rnd);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Sampling kNN distances", size, LOG) : null;
        double[] knnDistances = new double[size];
        int i = 0;
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            knnDistances[i++] = knnQuery.getKNN((Object)iditer, this.k + 1).getKNNDistance();
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        return new KNNDistanceOrderResult(knnDistances, this.k);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("knndistanceorder.k", "Specifies the distance of the k-distant object to be assessed, ignoring the query object.");
        public static final OptionID SAMPLING_ID = new OptionID("knndistanceorder.sample", "The percentage of objects to use for sampling, or the absolute number of samples.");
        public static final OptionID SEED_ID = new OptionID("knndistanceorder.seed", "Random generator seed for sampling.");
        protected Distance<? super O> distance;
        protected int k;
        protected double percentage;
        protected RandomFactory rnd;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((DoubleParameter)new DoubleParameter(SAMPLING_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.percentage = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public KNNDistancesSampler<O> make() {
            return new KNNDistancesSampler<O>(this.distance, this.k, this.percentage, this.rnd);
        }
    }

    public static class KNNDistanceOrderResult
    extends XYCurve {
        public KNNDistanceOrderResult(double[] knnDistances, int k) {
            super("Objects", k + "-NN-distance", knnDistances.length + 1);
            Arrays.sort(knnDistances);
            for (int j = 0; j < knnDistances.length; ++j) {
                this.addAndSimplify(knnDistances.length - j, knnDistances[j]);
            }
            Metadata.of((Object)((Object)this)).setLongName(k + "-NN distance order");
        }
    }
}

