/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm;

import elki.Algorithm;
import elki.data.spatial.SpatialComparable;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.Relation;
import elki.distance.SpatialPrimitiveDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.tree.LeafEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.datastructures.heap.ComparableMinHeap;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.MissingPrerequisitesException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="K-Nearest Neighbor Join")
@Description(value="Algorithm to find the k-nearest neighbors of each object in a spatial database")
@Priority(value=-10)
public class KNNJoin
implements Algorithm {
    private static final Logging LOG = Logging.getLogger(KNNJoin.class);
    protected SpatialPrimitiveDistance<?> distance;
    protected int k;

    public KNNJoin(SpatialPrimitiveDistance<?> distance, int k) {
        this.distance = distance;
        this.k = k;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.SPATIAL_OBJECT});
    }

    public Relation<KNNList> autorun(Database database) {
        return this.run((Relation<? extends SpatialComparable>)database.getRelation((TypeInformation)TypeUtil.SPATIAL_OBJECT, new Object[0]));
    }

    public Relation<KNNList> run(Relation<? extends SpatialComparable> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDataStore<KNNList> knnLists = this.run(relation, ids);
        return new MaterializedRelation("k Nearest Neighbors", TypeUtil.KNNLIST, ids, knnLists);
    }

    public WritableDataStore<KNNList> run(Relation<? extends SpatialComparable> relation, DBIDs ids) {
        It indexes = Metadata.hierarchyOf(relation).iterDescendants().filter(AbstractRStarTree.class);
        if (!indexes.valid()) {
            throw new MissingPrerequisitesException("KNNJoin found no spatial indexes, expected exactly one.");
        }
        AbstractRStarTree index = (AbstractRStarTree)indexes.get();
        if (indexes.advance().valid()) {
            throw new MissingPrerequisitesException("KNNJoin found more than one spatial indexes, expected exactly one.");
        }
        return this.run(index, ids);
    }

    public WritableDataStore<KNNList> run(AbstractRStarTree<?, ?, ?> idx, DBIDs ids) {
        IndefiniteProgress fprogress;
        List pr_heaps;
        AbstractRStarTree<?, ?, ?> index = idx;
        List ps_candidates = index.getLeaves();
        ArrayList<List<KNNHeap>> heaps = new ArrayList<List<KNNHeap>>(ps_candidates.size());
        for (int i = 0; i < ps_candidates.size(); ++i) {
            heaps.add(this.initHeaps(this.distance, (AbstractRStarTreeNode)index.getNode((Object)((SpatialEntry)ps_candidates.get(i)))));
        }
        int sqsize = ps_candidates.size() * (ps_candidates.size() - 1) >>> 1;
        ComparableMinHeap pq = new ComparableMinHeap(sqsize);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine((CharSequence)("Number of leaves: " + ps_candidates.size() + " so " + sqsize + " MBR computations."));
        }
        FiniteProgress mprogress = LOG.isVerbose() ? new FiniteProgress("Comparing leaf MBRs", sqsize, LOG) : null;
        for (int i = 0; i < ps_candidates.size(); ++i) {
            SpatialEntry pr_entry = (SpatialEntry)ps_candidates.get(i);
            AbstractRStarTreeNode pr = (AbstractRStarTreeNode)index.getNode((Object)pr_entry);
            pr_heaps = (List)heaps.get(i);
            double pr_knn_distance = this.computeStopDistance(pr_heaps);
            for (int j = i + 1; j < ps_candidates.size(); ++j) {
                SpatialEntry ps_entry = (SpatialEntry)ps_candidates.get(j);
                AbstractRStarTreeNode ps = (AbstractRStarTreeNode)index.getNode((Object)ps_entry);
                List ps_heaps = (List)heaps.get(j);
                double ps_knn_distance = this.computeStopDistance(ps_heaps);
                double minDist = this.distance.minDist((SpatialComparable)pr_entry, (SpatialComparable)ps_entry);
                if (minDist <= 0.0) {
                    this.processDataPages(this.distance, pr_heaps, ps_heaps, pr, ps);
                } else if (minDist <= pr_knn_distance || minDist <= ps_knn_distance) {
                    pq.add((Comparable)new Task(minDist, i, j));
                }
                LOG.incrementProcessed((AbstractProgress)mprogress);
            }
        }
        LOG.ensureCompleted(mprogress);
        FiniteProgress qprogress = LOG.isVerbose() ? new FiniteProgress("Processing queue", pq.size(), LOG) : null;
        IndefiniteProgress indefiniteProgress = fprogress = LOG.isVerbose() ? new IndefiniteProgress("Full comparisons", LOG) : null;
        while (!pq.isEmpty()) {
            boolean dos;
            Task task = (Task)pq.poll();
            pr_heaps = (List)heaps.get(task.i);
            List ps_heaps = (List)heaps.get(task.j);
            double pr_knn_distance = this.computeStopDistance(pr_heaps);
            double ps_knn_distance = this.computeStopDistance(ps_heaps);
            boolean dor = task.mindist <= pr_knn_distance;
            boolean bl = dos = task.mindist <= ps_knn_distance;
            if (dor || dos) {
                AbstractRStarTreeNode pr = (AbstractRStarTreeNode)index.getNode((Object)((SpatialEntry)ps_candidates.get(task.i)));
                AbstractRStarTreeNode ps = (AbstractRStarTreeNode)index.getNode((Object)((SpatialEntry)ps_candidates.get(task.j)));
                if (dor && dos) {
                    this.processDataPages(this.distance, pr_heaps, ps_heaps, pr, ps);
                } else if (dor) {
                    this.processDataPages(this.distance, pr_heaps, null, pr, ps);
                } else {
                    this.processDataPages(this.distance, ps_heaps, null, ps, pr);
                }
                LOG.incrementProcessed((AbstractProgress)fprogress);
            }
            LOG.incrementProcessed((AbstractProgress)qprogress);
        }
        LOG.ensureCompleted(qprogress);
        LOG.setCompleted(fprogress);
        WritableDataStore knnLists = DataStoreUtil.makeStorage((DBIDs)ids, (int)4, KNNList.class);
        FiniteProgress pageprog = LOG.isVerbose() ? new FiniteProgress("Number of processed data pages", ps_candidates.size(), LOG) : null;
        for (int i = 0; i < ps_candidates.size(); ++i) {
            AbstractRStarTreeNode pr = (AbstractRStarTreeNode)index.getNode((Object)((SpatialEntry)ps_candidates.get(i)));
            List pr_heaps2 = (List)heaps.get(i);
            for (int j = 0; j < pr.getNumEntries(); ++j) {
                knnLists.put((DBIDRef)((LeafEntry)pr.getEntry(j)).getDBID(), (Object)((KNNHeap)pr_heaps2.get(j)).toKNNList());
            }
            heaps.set(i, null);
            LOG.incrementProcessed((AbstractProgress)pageprog);
        }
        LOG.ensureCompleted(pageprog);
        return knnLists;
    }

    private List<KNNHeap> initHeaps(SpatialPrimitiveDistance<?> distFunction, AbstractRStarTreeNode<?, ?> pr) {
        ArrayList<KNNHeap> pr_heaps = new ArrayList<KNNHeap>(pr.getNumEntries());
        for (int j = 0; j < pr.getNumEntries(); ++j) {
            pr_heaps.add(DBIDUtil.newHeap((int)this.k));
        }
        this.processDataPages(distFunction, pr_heaps, null, pr, pr);
        return pr_heaps;
    }

    private void processDataPages(SpatialPrimitiveDistance<?> df, List<KNNHeap> pr_heaps, List<KNNHeap> ps_heaps, AbstractRStarTreeNode<?, ?> pr, AbstractRStarTreeNode<?, ?> ps) {
        for (int j = 0; j < ps.getNumEntries(); ++j) {
            SpatialPointLeafEntry s_e = (SpatialPointLeafEntry)ps.getEntry(j);
            KNNHeap hj = ps_heaps != null ? ps_heaps.get(j) : null;
            DBID s_id = s_e.getDBID();
            for (int i = 0; i < pr.getNumEntries(); ++i) {
                SpatialPointLeafEntry r_e = (SpatialPointLeafEntry)pr.getEntry(i);
                double distance = df.minDist((SpatialComparable)s_e, (SpatialComparable)r_e);
                pr_heaps.get(i).insert(distance, (DBIDRef)s_id);
                if (hj == null) continue;
                hj.insert(distance, (DBIDRef)r_e.getDBID());
            }
        }
    }

    private double computeStopDistance(List<KNNHeap> heaps) {
        double pr_knn_distance = Double.NaN;
        for (KNNHeap knnList : heaps) {
            double kdist = knnList.getKNNDistance();
            pr_knn_distance = kdist < pr_knn_distance ? pr_knn_distance : kdist;
        }
        return pr_knn_distance != pr_knn_distance ? Double.POSITIVE_INFINITY : pr_knn_distance;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("knnjoin.k", "Specifies the k-nearest neighbors to be assigned.");
        protected int k;
        protected SpatialPrimitiveDistance<?> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, SpatialPrimitiveDistance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public KNNJoin make() {
            return new KNNJoin(this.distance, this.k);
        }
    }

    private static class Task
    implements Comparable<Task> {
        final double mindist;
        final int i;
        final int j;

        public Task(double mindist, int i, int j) {
            this.mindist = mindist;
            this.i = i;
            this.j = j;
        }

        @Override
        public int compareTo(Task o) {
            return Double.compare(this.mindist, o.mindist);
        }
    }
}

