/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm.statistics;

import elki.Algorithm;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.math.DoubleMinMax;
import elki.math.scales.LinearScale;
import elki.result.ResultUtil;
import elki.result.ScalesResult;
import elki.utilities.documentation.Description;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.ListSizeConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleListParameter;

@Description(value="Setup a scaling so that all dimensions are scaled equally in visualization.")
public class AddSingleScale
implements Algorithm {
    double[] minmax = null;

    public AddSingleScale(double[] minmax) {
        this.minmax = minmax;
    }

    public Void run(Database database) {
        for (Relation rel : database.getRelations()) {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)rel.getDataTypeInformation())) continue;
            Relation vrel = rel;
            ResultUtil.addChildResult((Object)rel, (Object)this.run((Relation<? extends NumberVector>)vrel));
        }
        return null;
    }

    private ScalesResult run(Relation<? extends NumberVector> rel) {
        int dim = RelationUtil.dimensionality(rel);
        LinearScale[] scales = new LinearScale[dim];
        if (this.minmax == null) {
            DoubleMinMax mm = new DoubleMinMax();
            DBIDIter iditer = rel.iterDBIDs();
            while (iditer.valid()) {
                NumberVector vec = (NumberVector)rel.get((DBIDRef)iditer);
                for (int d = 0; d < dim; ++d) {
                    double val = vec.doubleValue(d);
                    if (val != val) continue;
                    mm.put(val);
                }
                iditer.advance();
            }
            LinearScale scale = new LinearScale(mm.getMin(), mm.getMax());
            for (int i = 0; i < dim; ++i) {
                scales[i] = scale;
            }
        } else {
            LinearScale scale = new LinearScale(this.minmax[0], this.minmax[1]);
            for (int i = 0; i < dim; ++i) {
                scales[i] = scale;
            }
        }
        ScalesResult res = new ScalesResult(scales);
        return res;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MINMAX_ID = new OptionID("scales.minmax", "Forcibly set the scales to the given range.");
        double[] minmax = null;

        public void configure(Parameterization config) {
            ((DoubleListParameter)((DoubleListParameter)new DoubleListParameter(MINMAX_ID).setOptional(true)).addConstraint((ParameterConstraint)new ListSizeConstraint(2))).grab(config, x -> {
                this.minmax = (double[])x.clone();
            });
        }

        public AddSingleScale make() {
            return new AddSingleScale(this.minmax);
        }
    }
}

