/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm.statistics;

import elki.Algorithm;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.math.MathUtil;
import elki.math.scales.LinearScale;
import elki.result.ResultUtil;
import elki.result.ScalesResult;
import elki.utilities.documentation.Description;

@Description(value="Setup a scaling so that all dimensions have the same value range.")
public class AddUniformScale
implements Algorithm {
    public Void run(Database database) {
        for (Relation rel : database.getRelations()) {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)rel.getDataTypeInformation())) continue;
            Relation vrel = rel;
            ResultUtil.addChildResult((Object)rel, (Object)this.run((Relation<? extends NumberVector>)vrel));
        }
        return null;
    }

    private ScalesResult run(Relation<? extends NumberVector> rel) {
        double[][] mms = RelationUtil.computeMinMax(rel);
        int dim = mms[0].length;
        double delta = 0.0;
        for (int d = 0; d < dim; ++d) {
            double del = mms[1][d] - mms[0][d];
            delta = del > delta ? del : delta;
        }
        if (delta < Double.MIN_NORMAL) {
            delta = 1.0;
        }
        int log10res = (int)Math.ceil(Math.log10(delta / 30.0));
        double res = MathUtil.powi((double)10.0, (int)log10res);
        double target = Math.ceil(delta / res) * res;
        LinearScale[] scales = new LinearScale[dim];
        for (int d = 0; d < dim; ++d) {
            double mid = (mms[0][d] + mms[1][d] - target) * 0.5;
            double min = Math.floor(mid / res) * res;
            double max = Math.ceil((mid + target) / res) * res;
            scales[d] = new LinearScale(min, max);
        }
        return new ScalesResult(scales);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }
}

