/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm.statistics;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.result.CollectionResult;
import elki.result.Metadata;
import elki.utilities.datastructures.heap.DoubleMaxHeap;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DistanceQuantileSampler<O>
implements Algorithm {
    private static final Logging LOG = Logging.getLogger(DistanceQuantileSampler.class);
    private static final String PREFIX = DistanceQuantileSampler.class.getName();
    private Distance<? super O> distance;
    private double quantile;
    private double sampling;
    private boolean nozeros;
    private RandomFactory rand;

    public DistanceQuantileSampler(Distance<? super O> distance, double quantile, double sampling, boolean nozeros, RandomFactory rand) {
        this.distance = distance;
        this.quantile = quantile;
        this.sampling = sampling;
        this.nozeros = nozeros;
        this.rand = rand;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public CollectionResult<double[]> run(Relation<O> relation) {
        long ssize;
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        int size = relation.size();
        long pairs = (long)size * (long)size >> 1;
        long l = ssize = this.sampling <= 1.0 ? (long)Math.ceil(this.sampling * (double)pairs) : (long)this.sampling;
        if (ssize > Integer.MAX_VALUE) {
            throw new AbortException("Sampling size too large.");
        }
        int qsize = this.quantile <= 0.0 ? 1 : (int)Math.ceil(this.quantile * (double)ssize);
        DoubleMaxHeap heap = new DoubleMaxHeap(qsize);
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        DBIDArrayIter i1 = ids.iter();
        DBIDArrayIter i2 = ids.iter();
        Random r = this.rand.getSingleThreadedRandom();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Sampling", (int)ssize, LOG) : null;
        for (long i = 0L; i < ssize; ++i) {
            int x = r.nextInt(size - 1) + 1;
            int y = r.nextInt(x);
            double dist = dq.distance((DBIDRef)i1.seek(x), (DBIDRef)i2.seek(y));
            if (dist != dist || this.nozeros && dist < Double.MIN_NORMAL) continue;
            heap.add(dist, qsize);
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.statistics((Statistic)new DoubleStatistic(PREFIX + ".quantile", this.quantile));
        LOG.statistics((Statistic)new LongStatistic(PREFIX + ".samplesize", ssize));
        LOG.statistics((Statistic)new DoubleStatistic(PREFIX + ".distance", heap.peek()));
        LOG.ensureCompleted(prog);
        List<String> header = Arrays.asList("Distance");
        List data = Arrays.asList(new double[][]{{heap.peek()}});
        CollectionResult result = new CollectionResult(data, header);
        Metadata.of((Object)result).setLongName("Distances Sample");
        return result;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID QUANTILE_ID = new OptionID("distsample.quantile", "Quantile to compute.");
        public static final OptionID SAMPLING_ID = new OptionID("distsample.sample", "Number of distances to compute, either relative (values less than 1), or absolute.");
        public static final OptionID NOZEROS_ID = new OptionID("distsample.nozeros", "Ignore zero distances, beneficial for data sets with many duplicates.");
        public static final OptionID SEED_ID = new OptionID("distsample.seed", "Random generator seed.");
        protected Distance<? super O> distance;
        protected double quantile;
        protected double sampling;
        protected boolean nozeros;
        protected RandomFactory rand;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(QUANTILE_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).grab(config, x -> {
                this.quantile = x;
            });
            ((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.sampling = x;
            });
            new Flag(NOZEROS_ID).grab(config, x -> {
                this.nozeros = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rand = x;
            });
        }

        public DistanceQuantileSampler<O> make() {
            return new DistanceQuantileSampler<O>(this.distance, this.quantile, this.sampling, this.nozeros, this.rand);
        }
    }
}

