/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm.statistics;

import elki.Algorithm;
import elki.clustering.trivial.ByLabelOrAllInOneClustering;
import elki.data.Cluster;
import elki.data.NumberVector;
import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.clustering.EvaluateClustering;
import elki.evaluation.scores.ROCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MeanVariance;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.math.linearalgebra.VMath;
import elki.result.HistogramResult;
import elki.result.Metadata;
import elki.utilities.datastructures.histogram.ObjHistogram;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Title(value="Evaluate Ranking Quality")
@Description(value="Evaluates the effectiveness of a distance function via the obtained rankings.")
public class EvaluateRankingQuality<V extends NumberVector>
implements Algorithm {
    private static final Logging LOG = Logging.getLogger(EvaluateRankingQuality.class);
    protected Distance<? super V> distance;
    protected int numbins = 20;

    public EvaluateRankingQuality(Distance<? super V> distance, int numbins) {
        this.distance = distance;
        this.numbins = numbins;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{new CombinedTypeInformation(new TypeInformation[]{this.distance.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD})});
    }

    public HistogramResult run(Database database, Relation<V> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(relation.size());
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Preprocessing clusters...");
        }
        List split = new ByLabelOrAllInOneClustering().autorun(database).getAllClusters();
        HashMap<Cluster, double[]> averages = new HashMap<Cluster, double[]>(split.size());
        HashMap<Cluster, double[][]> covmats = new HashMap<Cluster, double[][]>(split.size());
        for (Cluster clus : split) {
            CovarianceMatrix covmat = CovarianceMatrix.make(relation, (DBIDs)clus.getIDs());
            averages.put(clus, covmat.getMeanVector());
            covmats.put(clus, covmat.destroyToPopulationMatrix());
        }
        ObjHistogram hist = new ObjHistogram(this.numbins, 0.0, 1.0, MeanVariance::new);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Processing points...");
        }
        FiniteProgress rocloop = LOG.isVerbose() ? new FiniteProgress("Computing AUROC values", relation.size(), LOG) : null;
        ROCEvaluation roc = new ROCEvaluation();
        for (Cluster clus : split) {
            ModifiableDoubleDBIDList cmem = DBIDUtil.newDistanceDBIDList((int)clus.size());
            double[] av = (double[])averages.get(clus);
            double[][] covm = (double[][])covmats.get(clus);
            DBIDIter iter = clus.getIDs().iter();
            while (iter.valid()) {
                double[] v = VMath.minusEquals((double[])((NumberVector)relation.get((DBIDRef)iter)).toArray(), (double[])av);
                cmem.add(VMath.transposeTimesTimes((double[])v, (double[][])covm, (double[])v), (DBIDRef)iter);
                iter.advance();
            }
            cmem.sort();
            DoubleDBIDListMIter it = cmem.iter();
            while (it.valid()) {
                KNNList knn = knnQuery.getKNN((Object)it, relation.size());
                double result = EvaluateClustering.evaluateRanking((ScoreEvaluation)roc, (Cluster)clus, (DoubleDBIDList)knn);
                ((MeanVariance)hist.get((double)it.getOffset() / (double)clus.size())).put(result);
                LOG.incrementProcessed((AbstractProgress)rocloop);
                it.advance();
            }
        }
        LOG.ensureCompleted(rocloop);
        ArrayList<double[]> res = new ArrayList<double[]>(relation.size());
        ObjHistogram.Iter iter = hist.iter();
        while (iter.valid()) {
            res.add(new double[]{iter.getCenter(), ((MeanVariance)iter.getValue()).getCount(), ((MeanVariance)iter.getValue()).getMean(), ((MeanVariance)iter.getValue()).getSampleVariance()});
            iter.advance();
        }
        HistogramResult result = new HistogramResult(res);
        Metadata.of((Object)result).setLongName("Ranking Quality Histogram");
        return result;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("rankqual.bins", "Number of bins to use in the histogram");
        protected Distance<? super V> distance;
        protected int numbins = 20;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(HISTOGRAM_BINS_ID, 20).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.numbins = x;
            });
        }

        public EvaluateRankingQuality<V> make() {
            return new EvaluateRankingQuality<V>(this.distance, this.numbins);
        }
    }
}

