/*
 * Decompiled with CFR 0.152.
 */
package elki.algorithm.statistics;

import elki.Algorithm;
import elki.clustering.trivial.ByLabelOrAllInOneClustering;
import elki.data.Cluster;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.clustering.EvaluateClustering;
import elki.evaluation.scores.ROCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MeanVariance;
import elki.result.HistogramResult;
import elki.result.Metadata;
import elki.utilities.datastructures.histogram.DoubleHistogram;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="Ranking Quality Histogram")
@Description(value="Evaluates the effectiveness of a distance function via the obtained rankings.")
public class RankingQualityHistogram<O>
implements Algorithm {
    private static final Logging LOG = Logging.getLogger(RankingQualityHistogram.class);
    protected Distance<? super O> distance;
    protected int numbins = 100;

    public RankingQualityHistogram(Distance<? super O> distance, int numbins) {
        this.distance = distance;
        this.numbins = numbins;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public HistogramResult run(Database database, Relation<O> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(relation.size());
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Preprocessing clusters...");
        }
        List split = new ByLabelOrAllInOneClustering().autorun(database).getAllClusters();
        DoubleHistogram hist = new DoubleHistogram(this.numbins, 0.0, 1.0);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Processing points...");
        }
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Computing AUROC values", relation.size(), LOG) : null;
        ROCEvaluation roc = new ROCEvaluation();
        MeanVariance mv = new MeanVariance();
        for (Cluster clus : split) {
            DBIDIter iter = clus.getIDs().iter();
            while (iter.valid()) {
                KNNList knn = knnQuery.getKNN((Object)iter, relation.size());
                double result = EvaluateClustering.evaluateRanking((ScoreEvaluation)roc, (Cluster)clus, (DoubleDBIDList)knn);
                mv.put(result);
                hist.increment(result, 1.0 / (double)relation.size());
                LOG.incrementProcessed((AbstractProgress)progress);
                iter.advance();
            }
        }
        LOG.ensureCompleted(progress);
        ArrayList<double[]> res = new ArrayList<double[]>(relation.size());
        DoubleHistogram.Iter iter = hist.iter();
        while (iter.valid()) {
            res.add(new double[]{iter.getCenter(), iter.getValue()});
            iter.advance();
        }
        HistogramResult result = new HistogramResult(res);
        Metadata.of((Object)result).setLongName("Ranking Quality Histogram");
        result.addHeader("Mean: " + mv.getMean() + " Variance: " + mv.getSampleVariance());
        return result;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("rankqual.bins", "Number of bins to use in the histogram");
        protected Distance<? super O> distance;
        protected int numbins = 20;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(HISTOGRAM_BINS_ID, 100).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.numbins = x;
            });
        }

        public RankingQualityHistogram<O> make() {
            return new RankingQualityHistogram<O>(this.distance, this.numbins);
        }
    }
}

