/*
 * Decompiled with CFR 0.152.
 */
package elki.application;

import elki.application.AbstractApplication;
import elki.application.KDDCLIApplication;
import elki.logging.LoggingUtil;
import elki.utilities.ELKIServiceRegistry;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class ELKILauncher {
    public static final Class<? extends AbstractApplication> DEFAULT_APPLICATION;

    private ELKILauncher() {
    }

    public static void main(String[] args) {
        Class cls;
        if (args.length > 0 && args[0].charAt(0) != '-' && (cls = ELKIServiceRegistry.findImplementation(AbstractApplication.class, (String)args[0])) != null) {
            try {
                Method m = cls.getMethod("main", String[].class);
                String[] a = Arrays.copyOfRange(args, 1, args.length);
                m.invoke(null, new Object[]{a});
            }
            catch (InvocationTargetException e) {
                LoggingUtil.exception((Throwable)e.getCause());
            }
            catch (Exception e) {
                LoggingUtil.exception((Throwable)e);
            }
            return;
        }
        try {
            Method m = DEFAULT_APPLICATION.getMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            LoggingUtil.exception((Throwable)e);
        }
    }

    static {
        Class clz = KDDCLIApplication.class;
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                Class<?> minigui = Class.forName("elki.gui.minigui.MiniGUI");
                clz = minigui;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DEFAULT_APPLICATION = clz;
    }
}

