/*
 * Decompiled with CFR 0.152.
 */
package elki.application.benchmark;

import elki.application.AbstractDistanceBasedApplication;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.distance.Distance;
import elki.index.Index;
import elki.logging.Logging;
import elki.logging.LoggingConfiguration;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.MillisTimeDuration;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.MathUtil;
import elki.math.MeanVariance;
import elki.result.Metadata;
import elki.utilities.Util;
import elki.utilities.datastructures.arrays.ArrayUtil;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.exceptions.IncompatibleDataException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import elki.workflow.InputStep;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;

public class KNNBenchmark<O>
extends AbstractDistanceBasedApplication<O> {
    private static final Logging LOG = Logging.getLogger(KNNBenchmark.class);
    protected int k = 10;
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected RandomFactory random;

    public KNNBenchmark(InputStep inputstep, Distance<? super O> distance, int k, DatabaseConnection queries, double sampling, RandomFactory random) {
        super(inputstep, distance);
        this.k = k;
        this.queries = queries;
        this.sampling = sampling;
        this.random = random;
    }

    public void run() {
        int hash;
        if (!LOG.isStatistics()) {
            LOG.error((CharSequence)"Logging level should be at least level STATISTICS (parameter -time) to see any output.");
        }
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        String key = ((Object)((Object)this)).getClass().getName();
        Duration dur = LOG.newDuration(key + ".duration");
        MeanVariance mv = new MeanVariance();
        MeanVariance mvdist = new MeanVariance();
        if (this.queries == null) {
            KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.k);
            this.logIndexStatistics(database);
            hash = this.run((KNNSearcher<DBIDRef>)knnQuery, relation, dur, mv, mvdist);
        } else {
            KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByObject(this.k);
            this.logIndexStatistics(database);
            hash = this.run(knnQuery, dur, mv, mvdist);
        }
        LOG.statistics((Statistic)dur.end());
        if (dur instanceof MillisTimeDuration) {
            LOG.statistics((Statistic)new StringStatistic(key + ".duration.avg", (double)dur.getDuration() / mv.getCount() * 1000.0 + " ns"));
        }
        LOG.statistics((Statistic)new DoubleStatistic(key + ".results.mean", mv.getMean()));
        LOG.statistics((Statistic)new DoubleStatistic(key + ".results.std", mv.getPopulationStddev()));
        LOG.statistics((Statistic)new DoubleStatistic(key + ".kdist.mean", mvdist.getMean()));
        LOG.statistics((Statistic)new DoubleStatistic(key + ".kdist.std", mvdist.getPopulationStddev()));
        this.logIndexStatistics(database);
        LOG.statistics((Statistic)new LongStatistic(key + ".checksum", (long)hash));
    }

    private void logIndexStatistics(Database database) {
        It it = Metadata.hierarchyOf((Object)database).iterDescendants().filter(Index.class);
        while (it.valid()) {
            ((Index)it.get()).logStatistics();
            it.advance();
        }
    }

    private int run(KNNSearcher<DBIDRef> knnQuery, Relation<O> relation, Duration dur, MeanVariance mv, MeanVariance mvdist) {
        int hash = 0;
        DBIDs sample = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (double)this.sampling, (RandomFactory)this.random);
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
        dur.begin();
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            KNNList knns = knnQuery.getKNN((Object)iditer, this.k);
            int ichecksum = 0;
            DoubleDBIDListIter it = knns.iter();
            while (it.valid()) {
                ichecksum += DBIDUtil.asInteger((DBIDRef)it);
                it.advance();
            }
            hash = Util.mixHashCodes((int)hash, (int)ichecksum);
            mv.put((double)knns.size());
            mvdist.put(knns.getKNNDistance());
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        dur.end();
        LOG.ensureCompleted(prog);
        return hash;
    }

    private int run(KNNSearcher<O> knnQuery, Duration dur, MeanVariance mv, MeanVariance mvdist) {
        int hash = 0;
        TypeInformation res = this.distance.getInputTypeRestriction();
        MultipleObjectsBundle bundle = this.queries.loadData();
        int col = -1;
        for (int i = 0; i < bundle.metaLength(); ++i) {
            if (!res.isAssignableFromType((TypeInformation)bundle.meta(i))) continue;
            col = i;
            break;
        }
        if (col < 0) {
            throw new IncompatibleDataException("No compatible data type in query input was found. Expected: " + res.toString());
        }
        int[] sample = MathUtil.sequence((int)0, (int)bundle.dataLength());
        int samplesize = (int)(this.sampling <= 1.0 ? this.sampling * (double)sample.length : this.sampling);
        ArrayUtil.randomShuffle((int[])sample, (Random)this.random.getSingleThreadedRandom(), (int)samplesize);
        sample = Arrays.copyOf(sample, samplesize);
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.length, LOG) : null;
        dur.begin();
        for (int off : sample) {
            Object o = bundle.data(off, col);
            KNNList knns = knnQuery.getKNN(o, this.k);
            int ichecksum = 0;
            DoubleDBIDListIter it = knns.iter();
            while (it.valid()) {
                ichecksum += DBIDUtil.asInteger((DBIDRef)it);
                it.advance();
            }
            hash = Util.mixHashCodes((int)hash, (int)ichecksum);
            mv.put((double)knns.size());
            mvdist.put(knns.getKNNDistance());
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        dur.end();
        LOG.ensureCompleted(prog);
        return hash;
    }

    public static void main(String[] args) {
        LoggingConfiguration.setDefaultLevel((Level)Logging.Level.STATISTICS);
        KNNBenchmark.runCLIApplication(KNNBenchmark.class, (String[])args);
    }

    public static class Par<O>
    extends AbstractDistanceBasedApplication.Par<O> {
        public static final OptionID K_ID = new OptionID("knnbench.k", "Number of neighbors to retreive for kNN benchmarking.");
        public static final OptionID QUERY_ID = new OptionID("knnbench.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("knnbench.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID RANDOM_ID = new OptionID("knnbench.random", "Random generator for sampling.");
        protected int k = 10;
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected RandomFactory random;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(QUERY_ID, DatabaseConnection.class).setOptional(true).grab(config, x -> {
                this.queries = x;
            });
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).setOptional(true)).grab(config, x -> {
                this.sampling = x;
            });
            new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT).grab(config, x -> {
                this.random = x;
            });
        }

        public KNNBenchmark<O> make() {
            return new KNNBenchmark(this.inputstep, this.distance, this.k, this.queries, this.sampling, this.random);
        }
    }
}

