/*
 * Decompiled with CFR 0.152.
 */
package elki.application.benchmark;

import elki.application.AbstractDistanceBasedApplication;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.distance.Distance;
import elki.index.Index;
import elki.logging.Logging;
import elki.logging.LoggingConfiguration;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.MillisTimeDuration;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.MathUtil;
import elki.math.MeanVariance;
import elki.result.Metadata;
import elki.utilities.Util;
import elki.utilities.datastructures.arrays.ArrayUtil;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.exceptions.IncompatibleDataException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import elki.workflow.InputStep;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;

public class RangeQueryBenchmark<O extends NumberVector>
extends AbstractDistanceBasedApplication<O> {
    private static final Logging LOG = Logging.getLogger(RangeQueryBenchmark.class);
    protected double radius = Double.NaN;
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected RandomFactory random;

    public RangeQueryBenchmark(InputStep input, Distance<? super O> distance, double radius, double sampling, RandomFactory random) {
        super(input, distance);
        this.radius = radius;
        this.sampling = sampling;
        this.random = random;
    }

    public RangeQueryBenchmark(InputStep input, Distance<? super O> distance, DatabaseConnection queries, double sampling, RandomFactory random) {
        super(input, distance);
        this.queries = queries;
        this.sampling = sampling;
        this.random = random;
    }

    public void run() {
        int hash;
        if (!LOG.isStatistics()) {
            LOG.error((CharSequence)"Logging level should be at least level STATISTICS (parameter -time) to see any output.");
        }
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        String key = ((Object)((Object)this)).getClass().getName();
        Duration dur = LOG.newDuration(key + ".duration");
        MeanVariance mv = new MeanVariance();
        if (!Double.isNaN(this.radius)) {
            RangeSearcher rangeQuery = new QueryBuilder(relation, this.distance).rangeByDBID(this.radius);
            this.logIndexStatistics(database);
            hash = this.run((RangeSearcher<DBIDRef>)rangeQuery, relation, this.radius, dur, mv);
        } else if (this.queries != null) {
            RangeSearcher rangeQuery = new QueryBuilder(relation, this.distance).rangeByObject();
            this.logIndexStatistics(database);
            hash = this.run(rangeQuery, relation, this.queries, dur, mv);
        } else {
            RangeSearcher rangeQuery = new QueryBuilder(relation, this.distance).rangeByDBID();
            this.logIndexStatistics(database);
            Relation qrad = database.getRelation((TypeInformation)TypeUtil.NUMBER_VECTOR_FIELD_1D, new Object[0]);
            hash = this.run((RangeSearcher<DBIDRef>)rangeQuery, relation, (Relation<NumberVector>)qrad, dur, mv);
        }
        LOG.statistics((Statistic)dur.end());
        if (dur instanceof MillisTimeDuration) {
            LOG.statistics((Statistic)new StringStatistic(key + ".duration.avg", (double)dur.getDuration() / mv.getCount() * 1000.0 + " ns"));
        }
        LOG.statistics((Statistic)new DoubleStatistic(key + ".results.mean", mv.getMean()));
        LOG.statistics((Statistic)new DoubleStatistic(key + ".results.std", mv.getPopulationStddev()));
        this.logIndexStatistics(database);
        LOG.statistics((Statistic)new LongStatistic(key + ".checksum", (long)hash));
    }

    private void logIndexStatistics(Database database) {
        It it = Metadata.hierarchyOf((Object)database).iterDescendants().filter(Index.class);
        while (it.valid()) {
            ((Index)it.get()).logStatistics();
            it.advance();
        }
    }

    protected int run(RangeSearcher<DBIDRef> rangeQuery, Relation<O> relation, double radius, Duration dur, MeanVariance mv) {
        DBIDs sample = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (double)this.sampling, (RandomFactory)this.random);
        int hash = 0;
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
        dur.begin();
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            DoubleDBIDList rres = rangeQuery.getRange((Object)iditer, radius);
            hash = Util.mixHashCodes((int)hash, (int)this.processResult(rres, mv));
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        dur.end();
        LOG.ensureCompleted(prog);
        return hash;
    }

    protected int run(RangeSearcher<DBIDRef> rangeQuery, Relation<O> relation, Relation<NumberVector> radrel, Duration dur, MeanVariance mv) {
        DBIDs sample = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (double)this.sampling, (RandomFactory)this.random);
        int hash = 0;
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
        dur.begin();
        DBIDIter iditer = sample.iter();
        while (iditer.valid()) {
            DoubleDBIDList rres = rangeQuery.getRange((Object)iditer, ((NumberVector)radrel.get((DBIDRef)iditer)).doubleValue(0));
            hash = Util.mixHashCodes((int)hash, (int)this.processResult(rres, mv));
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        dur.end();
        LOG.ensureCompleted(prog);
        return hash;
    }

    protected int run(RangeSearcher<O> rangeQuery, Relation<O> relation, DatabaseConnection queries, Duration dur, MeanVariance mv) {
        NumberVector.Factory ofactory = RelationUtil.getNumberVectorFactory(relation);
        int dim = RelationUtil.dimensionality(relation);
        VectorFieldTypeInformation res = VectorFieldTypeInformation.typeRequest(NumberVector.class, (int)(dim + 1), (int)(dim + 1));
        MultipleObjectsBundle bundle = queries.loadData();
        int col = -1;
        for (int i = 0; i < bundle.metaLength(); ++i) {
            if (!res.isAssignableFromType((TypeInformation)bundle.meta(i))) continue;
            col = i;
            break;
        }
        if (col < 0) {
            StringBuilder buf = new StringBuilder(1000).append("No compatible data type in query input was found. Expected: ").append(res.toString()).append(" have:");
            for (int i = 0; i < bundle.metaLength(); ++i) {
                buf.append(' ').append(bundle.meta(i).toString());
            }
            throw new IncompatibleDataException(buf.toString());
        }
        int[] sample = MathUtil.sequence((int)0, (int)bundle.dataLength());
        int samplesize = (int)(this.sampling <= 1.0 ? this.sampling * (double)sample.length : this.sampling);
        ArrayUtil.randomShuffle((int[])sample, (Random)this.random.getSingleThreadedRandom(), (int)samplesize);
        sample = Arrays.copyOf(sample, samplesize);
        FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.length, LOG) : null;
        int hash = 0;
        dur.begin();
        double[] buf = new double[dim];
        for (int off : sample) {
            NumberVector o = (NumberVector)bundle.data(off, col);
            for (int i = 0; i < dim; ++i) {
                buf[i] = o.doubleValue(i);
            }
            DoubleDBIDList rres = rangeQuery.getRange((Object)ofactory.newNumberVector(buf), o.doubleValue(dim));
            hash = Util.mixHashCodes((int)hash, (int)this.processResult(rres, mv));
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        dur.end();
        LOG.ensureCompleted(prog);
        return hash;
    }

    protected int processResult(DoubleDBIDList rres, MeanVariance mv) {
        mv.put((double)rres.size());
        int ichecksum = 0;
        DoubleDBIDListIter it = rres.iter();
        while (it.valid()) {
            ichecksum += DBIDUtil.asInteger((DBIDRef)it);
            it.advance();
        }
        return ichecksum;
    }

    public static void main(String[] args) {
        LoggingConfiguration.setDefaultLevel((Level)Logging.Level.STATISTICS);
        RangeQueryBenchmark.runCLIApplication(RangeQueryBenchmark.class, (String[])args);
    }

    public static class Par<O extends NumberVector>
    extends AbstractDistanceBasedApplication.Par<O> {
        public static final OptionID RADIUS_ID = new OptionID("rangebench.radius", "Query radius to use a constant radius.");
        public static final OptionID QUERY_ID = new OptionID("rangebench.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("rangebench.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID RANDOM_ID = new OptionID("rangebench.random", "Random generator for sampling.");
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected double radius = Double.NaN;
        protected RandomFactory random;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((DoubleParameter)new DoubleParameter(RADIUS_ID).setOptional(true)).grab(config, x -> {
                this.radius = x;
            });
            if (Double.isNaN(this.radius)) {
                new ObjectParameter(QUERY_ID, DatabaseConnection.class).setOptional(true).grab(config, x -> {
                    this.queries = x;
                });
            }
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).setOptional(true)).grab(config, x -> {
                this.sampling = x;
            });
            new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT).grab(config, x -> {
                this.random = x;
            });
        }

        public RangeQueryBenchmark<O> make() {
            return Double.isNaN(this.radius) ? new RangeQueryBenchmark(this.inputstep, this.distance, this.queries, this.sampling, this.random) : new RangeQueryBenchmark(this.inputstep, this.distance, this.radius, this.sampling, this.random);
        }
    }
}

