/*
 * Decompiled with CFR 0.152.
 */
package elki.application.benchmark;

import elki.application.AbstractDistanceBasedApplication;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.LinearScanQuery;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MeanVariance;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import elki.workflow.InputStep;
import java.util.regex.Pattern;

public class ValidateApproximativeKNNIndex<O>
extends AbstractDistanceBasedApplication<O> {
    private static final Logging LOG = Logging.getLogger(ValidateApproximativeKNNIndex.class);
    protected int k = 10;
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected boolean forcelinear = false;
    protected RandomFactory random;
    protected Pattern pattern;

    public ValidateApproximativeKNNIndex(InputStep input, Distance<? super O> distance, int k, DatabaseConnection queries, double sampling, boolean forcelinear, RandomFactory random, Pattern pattern) {
        super(input, distance);
        this.k = k;
        this.queries = queries;
        this.sampling = sampling;
        this.forcelinear = forcelinear;
        this.random = random;
        this.pattern = pattern;
    }

    public void run() {
        if (!LOG.isStatistics()) {
            LOG.error((CharSequence)"Logging level should be at least level STATISTICS (parameter -time) to see any output.");
        }
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        MeanVariance mv = new MeanVariance();
        MeanVariance mvrec = new MeanVariance();
        MeanVariance mvdist = new MeanVariance();
        MeanVariance mvdaerr = new MeanVariance();
        MeanVariance mvdrerr = new MeanVariance();
        int misses = 0;
        if (this.queries == null || this.pattern != null) {
            KNNSearcher truekNNQuery;
            KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).optimizedOnly().kNNByDBID(this.k);
            if (knnQuery == null || knnQuery instanceof LinearScanQuery) {
                throw new AbortException("Expected an accelerated query, but got a linear scan -- index is not used.");
            }
            KNNSearcher kNNSearcher = truekNNQuery = this.forcelinear ? new QueryBuilder(relation, this.distance).linearOnly().kNNByDBID(this.k) : new QueryBuilder(relation, this.distance).exactOnly().kNNByDBID(this.k);
            if (knnQuery.getClass().equals(truekNNQuery.getClass())) {
                LOG.warning((CharSequence)"Query classes are the same. This experiment may be invalid!");
            }
            Relation lrel = this.pattern != null ? DatabaseUtil.guessLabelRepresentation((Database)database) : null;
            DBIDs sample = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (double)this.sampling, (RandomFactory)this.random);
            FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
            DBIDIter iditer = sample.iter();
            while (iditer.valid()) {
                if (this.pattern == null || this.pattern.matcher((CharSequence)lrel.get((DBIDRef)iditer)).find()) {
                    KNNList knns = knnQuery.getKNN((Object)iditer, this.k);
                    KNNList trueknns = truekNNQuery.getKNN((Object)iditer, this.k);
                    mv.put((double)(knns.size() * this.k) / (double)trueknns.size());
                    mvrec.put((double)DBIDUtil.intersectionSize((DBIDs)knns, (DBIDs)trueknns) / (double)trueknns.size());
                    if (knns.size() >= this.k) {
                        double kdist = knns.getKNNDistance();
                        double tdist = trueknns.getKNNDistance();
                        if (tdist > 0.0) {
                            mvdist.put(kdist);
                            mvdaerr.put(kdist - tdist);
                            mvdrerr.put(kdist / tdist);
                        }
                    } else {
                        ++misses;
                    }
                }
                LOG.incrementProcessed((AbstractProgress)prog);
                iditer.advance();
            }
            LOG.ensureCompleted(prog);
        } else {
            KNNSearcher truekNNQuery;
            KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).optimizedOnly().kNNByObject(this.k);
            if (knnQuery == null || knnQuery instanceof LinearScanQuery) {
                throw new AbortException("Expected an accelerated query, but got a linear scan -- index is not used.");
            }
            KNNSearcher kNNSearcher = truekNNQuery = this.forcelinear ? new QueryBuilder(relation, this.distance).linearOnly().kNNByObject(this.k) : new QueryBuilder(relation, this.distance).exactOnly().kNNByObject(this.k);
            if (knnQuery.getClass().equals(truekNNQuery.getClass())) {
                LOG.warning((CharSequence)"Query classes are the same. This experiment may be invalid!");
            }
            TypeInformation res = this.distance.getInputTypeRestriction();
            MultipleObjectsBundle bundle = this.queries.loadData();
            int col = -1;
            for (int i = 0; i < bundle.metaLength(); ++i) {
                if (!res.isAssignableFromType((TypeInformation)bundle.meta(i))) continue;
                col = i;
                break;
            }
            if (col < 0) {
                throw new AbortException("No compatible data type in query input was found. Expected: " + res.toString());
            }
            DBIDRange sids = DBIDUtil.generateStaticDBIDRange((int)bundle.dataLength());
            DBIDs sample = DBIDUtil.randomSample((DBIDs)sids, (double)this.sampling, (RandomFactory)this.random);
            FiniteProgress prog = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", sample.size(), LOG) : null;
            DBIDIter iditer = sample.iter();
            while (iditer.valid()) {
                int off = sids.binarySearch((DBIDRef)iditer);
                assert (off >= 0);
                Object o = bundle.data(off, col);
                KNNList knns = knnQuery.getKNN(o, this.k);
                KNNList trueknns = truekNNQuery.getKNN(o, this.k);
                mv.put((double)(knns.size() * this.k) / (double)trueknns.size());
                mvrec.put((double)DBIDUtil.intersectionSize((DBIDs)knns, (DBIDs)trueknns) / (double)trueknns.size());
                if (knns.size() >= this.k) {
                    double kdist = knns.getKNNDistance();
                    double tdist = trueknns.getKNNDistance();
                    if (tdist > 0.0) {
                        mvdist.put(kdist);
                        mvdaerr.put(kdist - tdist);
                        mvdrerr.put(kdist / tdist);
                    }
                } else {
                    ++misses;
                }
                LOG.incrementProcessed((AbstractProgress)prog);
                iditer.advance();
            }
            LOG.ensureCompleted(prog);
        }
        if (LOG.isStatistics()) {
            LOG.statistics((CharSequence)("Mean number of results: " + mv.getMean() + " +- " + mv.getPopulationStddev()));
            LOG.statistics((CharSequence)("Recall of true results: " + mvrec.getMean() + " +- " + mvrec.getPopulationStddev()));
            if (mvdist.getCount() > 0.0) {
                LOG.statistics((CharSequence)("Mean absolute k-error: " + mvdaerr.getMean() + " +- " + mvdaerr.getPopulationStddev()));
                LOG.statistics((CharSequence)("Mean relative k-error: " + mvdrerr.getMean() + " +- " + mvdrerr.getPopulationStddev()));
            }
            if (misses > 0) {
                LOG.statistics((CharSequence)String.format("Number of queries that returned less than k=%d objects: %d (%.2f%%)", this.k, misses, (double)misses * 100.0 / mv.getCount()));
            }
        }
    }

    public static class Par<O>
    extends AbstractDistanceBasedApplication.Par<O> {
        public static final OptionID K_ID = new OptionID("validateknn.k", "Number of neighbors to retreive for kNN benchmarking.");
        public static final OptionID QUERY_ID = new OptionID("validateknn.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("validateknn.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID FORCE_ID = new OptionID("validateknn.force-linear", "Force the use of linear scanning as reference.");
        public static final OptionID RANDOM_ID = new OptionID("validateknn.random", "Random generator for sampling.");
        public static final OptionID PATTERN_ID = new OptionID("validateknn.pattern", "Pattern to select query points.");
        protected int k = 10;
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected boolean forcelinear = false;
        protected RandomFactory random;
        protected Pattern pattern;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            if (!((PatternParameter)new PatternParameter(PATTERN_ID).setOptional(true)).grab(config, x -> {
                this.pattern = x;
            })) {
                new ObjectParameter(QUERY_ID, DatabaseConnection.class).setOptional(true).grab(config, x -> {
                    this.queries = x;
                });
            }
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).setOptional(true)).grab(config, x -> {
                this.sampling = x;
            });
            new Flag(FORCE_ID).grab(config, x -> {
                this.forcelinear = x;
            });
            new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT).grab(config, x -> {
                this.random = x;
            });
        }

        public ValidateApproximativeKNNIndex<O> make() {
            return new ValidateApproximativeKNNIndex(this.inputstep, this.distance, this.k, this.queries, this.sampling, this.forcelinear, this.random, this.pattern);
        }
    }
}

