/*
 * Decompiled with CFR 0.152.
 */
package elki.application.experiments;

import elki.Algorithm;
import elki.application.AbstractApplication;
import elki.clustering.ClusteringAlgorithm;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmedoids.AlternatingKMedoids;
import elki.clustering.kmedoids.EagerPAM;
import elki.clustering.kmedoids.FastPAM;
import elki.clustering.kmedoids.FastPAM1;
import elki.clustering.kmedoids.FasterPAM;
import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.ReynoldsPAM;
import elki.clustering.kmedoids.SingleAssignmentKMedoids;
import elki.clustering.kmedoids.initialization.BUILD;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.data.projection.random.RandomSubsetProjectionFamily;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.DBIDView;
import elki.database.relation.Relation;
import elki.distance.AbstractDBIDRangeDistance;
import elki.distance.DBIDDistance;
import elki.distance.Distance;
import elki.index.DistanceIndex;
import elki.logging.Logging;
import elki.logging.LoggingConfiguration;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.MathUtil;
import elki.result.Metadata;
import elki.utilities.io.FileUtil;
import elki.utilities.io.TokenizedReader;
import elki.utilities.io.Tokenizer;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Pattern;

public class ORLibBenchmark
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(ORLibBenchmark.class);
    private URI file = null;
    private Class<? extends ClusteringAlgorithm<?>> alg;
    private KMedoidsInitialization<DBID> init;
    private int k;
    private RandomFactory rnd;

    public ORLibBenchmark(URI file, Class<? extends ClusteringAlgorithm<?>> alg, KMedoidsInitialization<DBID> init, int k, RandomFactory rnd) {
        this.file = file;
        this.alg = alg;
        this.init = init;
        this.k = k;
        this.rnd = rnd;
    }

    public void run() {
        try (InputStream is = FileUtil.open((URI)this.file, (OpenOption[])new OpenOption[0]);
             TokenizedReader reader = new TokenizedReader(Pattern.compile(" "), null, Pattern.compile("^c "));){
            Clustering clustering;
            int n;
            reader.reset(is);
            Tokenizer tok = reader.getTokenizer();
            if (!reader.nextLine() || !tok.valid()) {
                throw new IOException("Empty file: " + this.file);
            }
            if (tok.isEmpty() || tok.getLength() == 1 && tok.getChar(0) == 'p') {
                tok.advance();
            }
            if ((n = tok.getIntBase10()) > 65535) {
                throw new ArrayIndexOutOfBoundsException("Distance matrix size overflow.");
            }
            if (!tok.advance().valid()) {
                throw new IOException("Invalid file format.");
            }
            int e = tok.getIntBase10();
            tok.advance();
            if (tok.valid()) {
                int p = tok.getIntBase10();
                int n2 = this.k = this.k > 0 ? this.k : p;
                if (tok.advance().valid()) {
                    throw new IOException("Invalid file format - extra entries.");
                }
            } else if (this.k <= 0) {
                throw new IllegalStateException("If the data set does not specify k, it must be given as parameter.");
            }
            double[] imat = ORLibBenchmark.readEdges(n, reader, tok);
            ORLibBenchmark.allShortestPaths(n, imat);
            final double[] mat = this.randomShuffle(n, imat);
            final DBIDRange ids = DBIDUtil.generateStaticDBIDRange((int)n);
            AbstractDBIDRangeDistance dist = new AbstractDBIDRangeDistance(){

                public void checkRange(DBIDRange range) {
                    if (range != ids) {
                        throw new IllegalArgumentException("Invalid DBID range");
                    }
                }

                public double distance(int i1, int i2) {
                    return i1 != i2 ? mat[ORLibBenchmark.computeOffset(i1, i2)] : 0.0;
                }
            };
            DBIDView view = new DBIDView((DBIDs)ids);
            Metadata.hierarchyOf((Object)view).addChild((Object)new DistanceIndex<DBID>((DBIDDistance)dist, view){
                final /* synthetic */ DBIDDistance val$dist;
                final /* synthetic */ DBIDView val$view;
                {
                    this.val$dist = dBIDDistance;
                    this.val$view = dBIDView;
                }

                public void initialize() {
                }

                public DistanceQuery<DBID> getDistanceQuery(Distance<? super DBID> distanceFunction) {
                    return distanceFunction == this.val$dist ? this.val$dist.instantiate((Relation)this.val$view) : null;
                }
            });
            Duration time = LOG.newDuration(ORLibBenchmark.class.getName() + ".time").begin();
            if (this.alg == null || SingleAssignmentKMedoids.class.equals(this.alg)) {
                clustering = new SingleAssignmentKMedoids((Distance)dist, this.k, this.init).run((Relation)view);
            } else if (PAM.class.equals(this.alg)) {
                clustering = new PAM((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else if (ReynoldsPAM.class.equals(this.alg)) {
                clustering = new ReynoldsPAM((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else if (AlternatingKMedoids.class.equals(this.alg)) {
                clustering = new AlternatingKMedoids((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else if (EagerPAM.class.equals(this.alg)) {
                clustering = new EagerPAM((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else if (FastPAM.class.equals(this.alg)) {
                clustering = new FastPAM((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else if (FastPAM1.class.equals(this.alg)) {
                clustering = new FastPAM1((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else if (FasterPAM.class.equals(this.alg)) {
                clustering = new FasterPAM((Distance)dist, this.k, -1, this.init).run((Relation)view);
            } else {
                throw new IllegalArgumentException("Unsupported algorithm: " + this.alg.toString());
            }
            LOG.statistics((Statistic)time.end());
            double cost = 0.0;
            for (Cluster cl : clustering.getAllClusters()) {
                int medoid = ids.getOffset((DBIDRef)((MedoidModel)cl.getModel()).getMedoid());
                DBIDIter iter = cl.getIDs().iter();
                while (iter.valid()) {
                    int ob = ids.getOffset((DBIDRef)iter);
                    cost += medoid != ob ? mat[ORLibBenchmark.computeOffset(medoid, ob)] : 0.0;
                    iter.advance();
                }
            }
            LOG.statistics((Statistic)new DoubleStatistic(((Object)((Object)this)).getClass().getName() + ".cost", cost));
        }
        catch (IOException e) {
            LOG.exception((Throwable)e);
        }
    }

    private static double[] readEdges(int n, TokenizedReader reader, Tokenizer tok) throws IOException {
        double[] mat = new double[n * (n - 1) >>> 1];
        Arrays.fill(mat, Double.POSITIVE_INFINITY);
        while (reader.nextLine() && tok.valid()) {
            try {
                if (tok.isEmpty() || tok.getLength() == 1 && (tok.getChar(0) == 'e' || tok.getChar(0) == 'a')) {
                    tok.advance();
                }
                int n1 = tok.getIntBase10();
                if (!tok.advance().valid()) {
                    throw new IOException("Invalid file format.");
                }
                int n2 = tok.getIntBase10();
                if (!tok.advance().valid()) {
                    throw new IOException("Invalid file format.");
                }
                double d = tok.getDouble();
                if (tok.advance().valid()) {
                    throw new IOException("Invalid file format.");
                }
                if (n1 == n2) {
                    if (d == 0.0) continue;
                    LOG.warning((CharSequence)("Non-zero self-edge in line #" + reader.getLineNumber() + ": " + reader.getBuffer()));
                    continue;
                }
                mat[ORLibBenchmark.computeOffset((int)(n1 - 1), (int)(n2 - 1))] = d;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse line #" + reader.getLineNumber() + ": " + reader.getBuffer(), ex);
            }
        }
        return mat;
    }

    private static void allShortestPaths(int n, double[] mat) {
        for (int i = 0; i < n; ++i) {
            int x = 0;
            int y = 1;
            int j = 0;
            while (j < mat.length) {
                if (x == y) {
                    ++y;
                    x = 0;
                }
                if (x != i && y != i) {
                    mat[j] = Math.min(mat[j], mat[ORLibBenchmark.computeOffset(x, i)] + mat[ORLibBenchmark.computeOffset(i, y)]);
                }
                ++j;
                ++x;
            }
        }
    }

    private double[] randomShuffle(int n, double[] mat) {
        if (this.rnd == null || this.rnd == RandomFactory.DEFAULT) {
            return mat;
        }
        int[] map = MathUtil.sequence((int)0, (int)n);
        RandomSubsetProjectionFamily.randomPermutation((int[])map, (Random)this.rnd.getSingleThreadedRandom());
        double[] mat2 = new double[mat.length];
        int x = 0;
        int y = 1;
        int mapy = map[1];
        int j = 0;
        while (j < mat.length) {
            if (x == y) {
                mapy = map[++y];
                x = 0;
            }
            mat2[ORLibBenchmark.computeOffset((int)map[x], (int)mapy)] = mat[j];
            ++j;
            ++x;
        }
        return mat2;
    }

    private static int computeOffset(int x, int y) {
        return x == y ? -1 : (y > x ? (y * (y - 1) >>> 1) + x : (x * (x - 1) >>> 1) + y);
    }

    public static void main(String[] args) {
        LoggingConfiguration.setStatistics();
        ORLibBenchmark.runCLIApplication(ORLibBenchmark.class, (String[])args);
    }

    public static class Par<O>
    extends AbstractApplication.Par {
        public static final OptionID FILE_ID = new OptionID("orlib.file", "Data file to load.");
        public static final OptionID SHUFFLE_ID = new OptionID("orlib.seed", "Random seed for shuffling.");
        private URI file = null;
        private Class<? extends ClusteringAlgorithm<?>> alg;
        private KMedoidsInitialization<DBID> init;
        int k;
        RandomFactory rnd;

        public void configure(Parameterization config) {
            new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.file = x;
            });
            ClassParameter algP = new ClassParameter(Algorithm.Utils.ALGORITHM_ID, ClusteringAlgorithm.class);
            if (config.grab((Parameter)algP)) {
                this.alg = (Class)algP.getValue();
            }
            new ObjectParameter(KMeans.INIT_ID, KMedoidsInitialization.class, BUILD.class).setOptional(true).grab(config, x -> {
                this.init = x;
            });
            ((IntParameter)new IntParameter(KMeans.K_ID).setOptional(true)).grab(config, x -> {
                this.k = x;
            });
            ((RandomParameter)new RandomParameter(SHUFFLE_ID).setOptional(true)).grab(config, x -> {
                this.rnd = x;
            });
        }

        public ORLibBenchmark make() {
            return new ORLibBenchmark(this.file, this.alg, this.init, this.k, this.rnd);
        }
    }
}

