/*
 * Decompiled with CFR 0.152.
 */
package elki.application.greedyensemble;

import elki.application.AbstractDistanceBasedApplication;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.knn.PreprocessorKNNQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import elki.math.statistics.intrinsicdimensionality.DistanceBasedIntrinsicDimensionalityEstimator;
import elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import elki.math.statistics.kernelfunctions.KernelDensityFunction;
import elki.outlier.DWOF;
import elki.outlier.anglebased.FastABOD;
import elki.outlier.distance.KNNDD;
import elki.outlier.distance.KNNOutlier;
import elki.outlier.distance.KNNSOS;
import elki.outlier.distance.KNNWeightOutlier;
import elki.outlier.distance.LocalIsolationCoefficient;
import elki.outlier.distance.ODIN;
import elki.outlier.intrinsic.IDOS;
import elki.outlier.intrinsic.ISOS;
import elki.outlier.intrinsic.LID;
import elki.outlier.lof.COF;
import elki.outlier.lof.INFLO;
import elki.outlier.lof.KDEOS;
import elki.outlier.lof.LDF;
import elki.outlier.lof.LDOF;
import elki.outlier.lof.LOF;
import elki.outlier.lof.LoOP;
import elki.outlier.lof.SimpleKernelDensityLOF;
import elki.outlier.lof.SimplifiedLOF;
import elki.outlier.lof.VarianceOfVolume;
import elki.outlier.trivial.ByLabelOutlier;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.similarity.Similarity;
import elki.similarity.kernel.LinearKernel;
import elki.utilities.datastructures.range.IntGenerator;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntGeneratorParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.LongParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.scaling.IdentityScaling;
import elki.utilities.scaling.ScalingFunction;
import elki.utilities.scaling.outlier.OutlierScaling;
import elki.workflow.InputStep;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import net.jafama.FastMath;

@Reference(authors="Erich Schubert, Remigius Wojdanowski, Arthur Zimek, Hans-Peter Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM Int. Conf. on Data Mining (SDM 2012)", url="https://doi.org/10.1137/1.9781611972825.90", bibkey="DBLP:conf/sdm/SchubertWZK12")
public class ComputeKNNOutlierScores<O extends NumberVector>
extends AbstractDistanceBasedApplication<O> {
    private static final Logging LOG = Logging.getLogger(ComputeKNNOutlierScores.class);
    final IntGenerator krange;
    Path outfile;
    ByLabelOutlier bylabel;
    ScalingFunction scaling;
    Pattern disable = null;
    int ksquarestop = 1000;
    long timelimit;

    public ComputeKNNOutlierScores(InputStep inputstep, Distance<? super O> distance, IntGenerator krange, ByLabelOutlier bylabel, Path outfile, ScalingFunction scaling, Pattern disable, int ksquarestop, long timelimit) {
        super(inputstep, distance);
        this.krange = krange;
        this.bylabel = bylabel;
        this.outfile = outfile;
        this.scaling = scaling;
        this.disable = disable;
        this.ksquarestop = ksquarestop;
        this.timelimit = timelimit * 1000L;
    }

    public void run() {
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        int maxk = Math.min(this.krange.getMax(), relation.size() - 1);
        int lim = Math.min(maxk + 2, relation.size());
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(lim);
        if (!(knnq instanceof PreprocessorKNNQuery)) {
            throw new AbortException("Not using preprocessor knn query -- KNN queries using class: " + knnq.getClass());
        }
        int maxksq = Math.min(maxk, this.ksquarestop);
        if (!this.isDisabled("FastABOD") && maxksq > 1000) {
            LOG.warning((CharSequence)("Note: FastABOD needs quadratic memory. Use -" + Par.DISABLE_ID.getName() + " FastABOD to disable."));
        }
        if (!this.isDisabled("LDOF") && maxksq > 1000) {
            LOG.verbose((CharSequence)("Note: LODF needs O(k^2) distance computations. Use -" + Par.DISABLE_ID.getName() + " LDOF to disable."));
        }
        if (!this.isDisabled("DWOF") && maxksq > 1000) {
            LOG.warning((CharSequence)("Note: DWOF needs O(k^2) distance computations. Use -" + Par.DISABLE_ID.getName() + " DWOF to disable."));
        }
        if (!this.isDisabled("COF") && maxksq > 1000) {
            LOG.warning((CharSequence)("Note: COF needs O(k^2) distance computations. Use -" + Par.DISABLE_ID.getName() + " COF to disable."));
        }
        DBIDs ids = relation.getDBIDs();
        try (BufferedWriter fout = Files.newBufferedWriter(this.outfile, new OpenOption[0]);){
            fout.append("# Data set size: " + relation.size()).append(" data type: " + relation.getDataTypeInformation()).append(FormatUtil.NEWLINE);
            this.writeResult(fout, ids, this.bylabel.autorun(database), (ScalingFunction)new IdentityScaling(), "bylabel");
            BiConsumer<String, OutlierResult> out = (kstr, result) -> this.writeResult(fout, ids, (OutlierResult)result, this.scaling, (String)kstr);
            this.runForEachK("KNN", 0, maxk, k -> new KNNOutlier(this.distance, k).run(relation), out);
            this.runForEachK("KNNW", 0, maxk, k -> new KNNWeightOutlier(this.distance, k).run(relation), out);
            this.runForEachK("LOF", 0, maxk, k -> new LOF(k, this.distance).run(relation), out);
            this.runForEachK("SimplifiedLOF", 0, maxk, k -> new SimplifiedLOF(this.distance, k).run(relation), out);
            this.runForEachK("LoOP", 0, maxk, k -> new LoOP(k, k, this.distance, this.distance, 1.0).run(relation), out);
            this.runForEachK("LDOF", 2, maxksq, k -> new LDOF(this.distance, k).run(relation), out);
            this.runForEachK("ODIN", 0, maxk, k -> new ODIN(this.distance, k).run(relation), out);
            this.runForEachK("KDEOS", 2, maxk, k -> new KDEOS(this.distance, k, k, (KernelDensityFunction)GaussianKernelDensityFunction.KERNEL, 0.0, 0.5 * GaussianKernelDensityFunction.KERNEL.canonicalBandwidth(), 2).run(relation), out);
            this.runForEachK("LDF", 0, maxk, k -> new LDF(k, this.distance, (KernelDensityFunction)GaussianKernelDensityFunction.KERNEL, 1.0, 0.1).run(relation), out);
            this.runForEachK("INFLO", 0, maxk, k -> new INFLO(this.distance, 1.0, k).run(relation), out);
            this.runForEachK("COF", 0, maxksq, k -> new COF(this.distance, k).run(relation), out);
            this.runForEachK("LID", 2, maxk, k -> new LID(this.distance, k, (IntrinsicDimensionalityEstimator)AggregatedHillEstimator.STATIC).run(relation), out);
            this.runForEachK("IDOS", 2, maxk, k -> new IDOS(this.distance, (IntrinsicDimensionalityEstimator)AggregatedHillEstimator.STATIC, k, k).run(relation), out);
            this.runForEachK("KDLOF", 2, maxk, k -> new SimpleKernelDensityLOF(k, this.distance, (KernelDensityFunction)GaussianKernelDensityFunction.KERNEL).run(relation), out);
            this.runForEachK("DWOF", 2, maxksq, k -> new DWOF(this.distance, k, 1.1).run(relation), out);
            this.runForEachK("LIC", 0, maxk, k -> new LocalIsolationCoefficient(this.distance, k).run(relation), out);
            if (TypeUtil.DOUBLE_VECTOR_FIELD.isAssignableFromType((TypeInformation)relation.getDataTypeInformation())) {
                Distance df = this.distance;
                Relation rel = relation;
                this.runForEachK("VOV", 0, maxk, k -> new VarianceOfVolume(k, df).run(rel), out);
            }
            this.runForEachK("KNNDD", 0, maxk, k -> new KNNDD(this.distance, k).run(relation), out);
            this.runForEachK("KNNSOS", 0, maxk, k -> new KNNSOS(this.distance, k).run(relation), out);
            this.runForEachK("ISOS", 2, maxk, k -> new ISOS(this.distance, k, (DistanceBasedIntrinsicDimensionalityEstimator)AggregatedHillEstimator.STATIC).run(relation), out);
            if (EuclideanDistance.STATIC.equals((Object)this.distance) || SquaredEuclideanDistance.STATIC.equals((Object)this.distance)) {
                this.runForEachK("FastABOD", 3, maxksq, k -> new FastABOD((Similarity)LinearKernel.STATIC, k).run(relation), out);
            }
        }
        catch (IOException e) {
            throw new AbortException("IO error writing output file.", (Throwable)e);
        }
        if (!(knnq instanceof PreprocessorKNNQuery)) {
            LOG.warning((CharSequence)"Not using preprocessor knn query. Runtime is suboptimal.");
        }
    }

    void writeResult(Appendable out, DBIDs ids, OutlierResult result, ScalingFunction scaling, String label) {
        try {
            if (scaling instanceof OutlierScaling) {
                ((OutlierScaling)scaling).prepare(result);
            }
            out.append(label);
            DoubleRelation scores = result.getScores();
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                double value = scores.doubleValue((DBIDRef)iter);
                value = scaling != null ? scaling.getScaled(value) : value;
                out.append(' ').append(Double.toString(value));
                iter.advance();
            }
            out.append(FormatUtil.NEWLINE);
        }
        catch (IOException e) {
            throw new AbortException("IO Error writing to file", (Throwable)e);
        }
    }

    private void runForEachK(String prefix, int mink, int maxk, IntFunction<OutlierResult> runner, BiConsumer<String, OutlierResult> out) {
        if (this.isDisabled(prefix)) {
            LOG.verbose((CharSequence)("Skipping (disabled): " + prefix));
            return;
        }
        LOG.verbose((CharSequence)("Running " + prefix));
        int digits = (int)FastMath.ceil((double)FastMath.log10((double)(this.krange.getMax() + 1)));
        String format = "%s-%0" + digits + "d";
        try {
            this.krange.forEach(k -> {
                if (k >= mink && k <= maxk) {
                    Duration time = LOG.newDuration(((Object)((Object)this)).getClass().getCanonicalName() + "." + prefix + ".k" + k + ".runtime").begin();
                    OutlierResult result = (OutlierResult)runner.apply(k);
                    LOG.statistics((Statistic)time.end());
                    if (result != null) {
                        out.accept(String.format(Locale.ROOT, format, prefix, k), result);
                        ResultUtil.removeRecursive((Object)result);
                    }
                    if (this.timelimit > 0L && time.getDuration() > this.timelimit) {
                        throw new TimeoutException("Timeout in " + prefix + " at k=" + k + ": " + time.getDuration());
                    }
                }
            });
        }
        catch (TimeoutException e) {
            LOG.error((CharSequence)e.getMessage());
        }
    }

    protected boolean isDisabled(String name) {
        return this.disable != null && this.disable.matcher(name).matches();
    }

    public static void main(String[] args) {
        ComputeKNNOutlierScores.runCLIApplication(ComputeKNNOutlierScores.class, (String[])args);
    }

    public static class Par<O extends NumberVector>
    extends AbstractDistanceBasedApplication.Par<O> {
        public static final OptionID KRANGE_ID = new OptionID("krange", "Range of k. This accepts multiple ranges, such as 1,2,..,10,20,..,100");
        public static final OptionID SCALING_ID = new OptionID("scaling", "Scaling function.");
        public static final OptionID DISABLE_ID = new OptionID("disable", "Disable methods (regular expression, case insensitive, anchored).");
        public static final OptionID KSQUARE_ID = new OptionID("ksquaremax", "Maximum k for methods with O(k^2) cost.");
        public static final OptionID TIMELIMIT_ID = new OptionID("timelimit", "Maximum run time per iteration in seconds (NOT strictly enforced).");
        IntGenerator krange;
        ByLabelOutlier bylabel;
        ScalingFunction scaling = null;
        Path outfile;
        Pattern disable = null;
        int ksquarestop = 100;
        long timelimit = -1L;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new IntGeneratorParameter(KRANGE_ID).grab(config, x -> {
                this.krange = x;
            });
            this.bylabel = (ByLabelOutlier)config.tryInstantiate(ByLabelOutlier.class);
            this.outfile = super.getParameterOutputFile(config, "File to output the resulting score vectors to.");
            new ObjectParameter(SCALING_ID, ScalingFunction.class).setOptional(true).grab(config, x -> {
                this.scaling = x;
            });
            ((PatternParameter)new PatternParameter(DISABLE_ID).setOptional(true)).grab(config, x -> {
                this.disable = x;
            });
            new IntParameter(KSQUARE_ID, 100).grab(config, x -> {
                this.ksquarestop = x;
            });
            new LongParameter(TIMELIMIT_ID, 43200L).grab(config, x -> {
                this.timelimit = x;
            });
        }

        public ComputeKNNOutlierScores<O> make() {
            return new ComputeKNNOutlierScores(this.inputstep, this.distance, this.krange, this.bylabel, this.outfile, this.scaling, this.disable, this.ksquarestop, this.timelimit);
        }
    }

    private static class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TimeoutException(String msg) {
            super(msg);
        }
    }
}

