/*
 * Decompiled with CFR 0.152.
 */
package elki.application.greedyensemble;

import elki.application.AbstractApplication;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.datasource.parser.StreamingParser;
import elki.evaluation.scores.AUPRCEvaluation;
import elki.evaluation.scores.AveragePrecisionEvaluation;
import elki.evaluation.scores.DCGEvaluation;
import elki.evaluation.scores.MaximumF1Evaluation;
import elki.evaluation.scores.NDCGEvaluation;
import elki.evaluation.scores.PRGCEvaluation;
import elki.evaluation.scores.PrecisionAtKEvaluation;
import elki.evaluation.scores.ROCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.DecreasingVectorIter;
import elki.evaluation.scores.adapter.IncreasingVectorIter;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.optionhandling.parameters.StringParameter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;

public class EvaluatePrecomputedOutlierScores
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(EvaluatePrecomputedOutlierScores.class);
    public static final String KNOWN_REVERSED = "(ODIN|DWOF|gaussian-model|silhouette|OutRank|OUTRES|aggarwal.?yu|ABOD)";
    URI infile;
    StreamingParser parser;
    Pattern reverse;
    Path outfile;
    String name;
    NumberVector positive;
    double endcg = 0.0;

    public EvaluatePrecomputedOutlierScores(URI infile, StreamingParser parser, Pattern reverse, Path outfile, String name) {
        this.infile = infile;
        this.parser = parser;
        this.reverse = reverse;
        this.outfile = outfile;
        this.name = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try (BufferedInputStream is = new BufferedInputStream(FileUtil.open((URI)this.infile, (OpenOption[])new OpenOption[0]));
             FileChannel chan = FileChannel.open(this.outfile, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
             PrintStream fout = new PrintStream(Channels.newOutputStream(chan));){
            this.parser.initStream((InputStream)is);
            chan.lock();
            if (chan.position() == 0L) {
                this.writeHeader(fout);
            } else {
                LOG.info((CharSequence)("Appending to existing output " + this.outfile));
            }
            int lcol = -1;
            int dcol = -1;
            while (true) {
                BundleStreamSource.Event ev = this.parser.nextEvent();
                switch (ev) {
                    case END_OF_STREAM: {
                        return;
                    }
                    case META_CHANGED: {
                        BundleMeta meta = this.parser.getMeta();
                        dcol = -1;
                        lcol = -1;
                        for (int i = 0; i < meta.size(); ++i) {
                            SimpleTypeInformation m = (SimpleTypeInformation)meta.get(i);
                            if (TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)m)) {
                                if (dcol >= 0) {
                                    throw new AbortException("More than one vector column.");
                                }
                                dcol = i;
                                continue;
                            }
                            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType((TypeInformation)m)) throw new AbortException("Unexpected data column type: " + m);
                            if (lcol >= 0) {
                                throw new AbortException("More than one label column.");
                            }
                            lcol = i;
                        }
                        break;
                    }
                    case NEXT_OBJECT: {
                        if (lcol < 0) {
                            throw new AbortException("No label column available.");
                        }
                        if (dcol < 0) {
                            throw new AbortException("No vector column available.");
                        }
                        this.processRow(fout, (NumberVector)this.parser.data(dcol), this.parser.data(lcol).toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AbortException("IO error.", (Throwable)e);
        }
    }

    private void writeHeader(PrintStream fout) {
        fout.append(this.name != null ? "\"Name\"," : "").append("\"Algorithm\",\"k\"").append(",\"AUROC\"").append(",\"AUPRC\"").append(",\"AUPRGC\"").append(",\"Average Precision\"").append(",\"R-Precision\"").append(",\"Maximum F1\"").append(",\"DCG\"").append(",\"NDCG\"").append(",\"Adjusted AUROC\"").append(",\"Adjusted AUPRC\"").append(",\"Adjusted AUPRGC\"").append(",\"Adjusted Average Precision\"").append(",\"Adjusted R-Precision\"").append(",\"Adjusted Maximum F1\"").append(",\"Adjusted DCG\"").append('\n');
    }

    private void processRow(PrintStream fout, NumberVector vec, String label) {
        if (this.checkForNaNs(vec)) {
            LOG.warning((CharSequence)("NaN value encountered in vector " + label));
            return;
        }
        if (this.positive == null) {
            if (!label.matches("bylabel")) {
                throw new AbortException("No 'by label' reference outlier found, which is needed for evaluation!");
            }
            this.positive = vec;
            return;
        }
        IncreasingVectorIter iter = this.reverse.matcher(label).find() ? new IncreasingVectorIter(this.positive, vec) : new DecreasingVectorIter(this.positive, vec);
        double expected = (double)iter.numPositive() / (double)this.positive.getDimensionality();
        double auroc = ROCEvaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double adjauroc = 2.0 * auroc - 1.0;
        double auprc = AUPRCEvaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double adjauprc = (auprc - expected) / (1.0 - expected);
        double auprgc = PRGCEvaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double adjauprgc = (auprgc - 0.5) * 2.0;
        double avep = AveragePrecisionEvaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double adjavep = (avep - expected) / (1.0 - expected);
        double rprecision = PrecisionAtKEvaluation.RPRECISION.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double adjrprecision = (rprecision - expected) / (1.0 - expected);
        double maxf1 = MaximumF1Evaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double adjmaxf1 = (maxf1 - expected) / (1.0 - expected);
        double dcg = DCGEvaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        double ndcg = NDCGEvaluation.STATIC.evaluate((ScoreEvaluation.Adapter)iter.seek(0));
        this.endcg = this.endcg > 0.0 ? this.endcg : NDCGEvaluation.STATIC.expected(iter.numPositive(), this.positive.getDimensionality());
        double adjdcg = (ndcg - this.endcg) / (1.0 - this.endcg);
        int p = label.lastIndexOf(45);
        String prefix = label.substring(0, p);
        int k = 0;
        try {
            k = Integer.valueOf(label.substring(p + 1));
        }
        catch (NumberFormatException e) {
            LOG.error((CharSequence)("Expected a number in label '" + label + "'"));
        }
        if (this.name != null) {
            fout.append('\"').append(this.name).append("\",");
        }
        fout.append('\"').append(prefix).append('\"').append(',').append(Integer.toString(k)).append(',').append(Double.toString(auroc)).append(',').append(Double.toString(auprc)).append(',').append(Double.toString(auprgc)).append(',').append(Double.toString(avep)).append(',').append(Double.toString(rprecision)).append(',').append(Double.toString(maxf1)).append(',').append(Double.toString(dcg)).append(',').append(Double.toString(ndcg)).append(',').append(Double.toString(adjauroc)).append(',').append(Double.toString(adjauprc)).append(',').append(Double.toString(adjauprgc)).append(',').append(Double.toString(adjavep)).append(',').append(Double.toString(adjrprecision)).append(',').append(Double.toString(adjmaxf1)).append(',').append(Double.toString(adjdcg)).append('\n');
    }

    private boolean checkForNaNs(NumberVector vec) {
        int d = vec.getDimensionality();
        for (int i = 0; i < d; ++i) {
            double v = vec.doubleValue(i);
            if (!Double.isNaN(v)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        EvaluatePrecomputedOutlierScores.runCLIApplication(EvaluatePrecomputedOutlierScores.class, (String[])args);
    }

    public static class Par
    extends AbstractApplication.Par {
        public static final OptionID NAME_ID = new OptionID("name", "Data set name to use in a 'Name' CSV column.");
        public static final OptionID PARSER_ID = new OptionID("parser", "Input parser.");
        public static final OptionID REVERSED_ID = new OptionID("reversed", "Pattern to recognize reversed methods.");
        URI infile;
        StreamingParser parser;
        Pattern reverse;
        Path outfile;
        String name;

        public void configure(Parameterization config) {
            super.configure(config);
            this.infile = super.getParameterInputFile(config, "Input file containing the outlier score vectors.");
            new ObjectParameter(PARSER_ID, StreamingParser.class, NumberVectorLabelParser.class).grab(config, x -> {
                this.parser = x;
            });
            this.outfile = super.getParameterOutputFile(config, "File to output the resulting evaluation vectors to.");
            ((StringParameter)new StringParameter(NAME_ID).setOptional(true)).grab(config, x -> {
                this.name = x;
            });
            new PatternParameter(REVERSED_ID, EvaluatePrecomputedOutlierScores.KNOWN_REVERSED).grab(config, x -> {
                this.reverse = x;
            });
        }

        public EvaluatePrecomputedOutlierScores make() {
            return new EvaluatePrecomputedOutlierScores(this.infile, this.parser, this.reverse, this.outfile, this.name);
        }
    }
}

