/*
 * Decompiled with CFR 0.152.
 */
package elki.application.statistics;

import elki.application.AbstractDistanceBasedApplication;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.math.statistics.intrinsicdimensionality.GEDEstimator;
import elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.random.RandomFactory;
import elki.workflow.InputStep;

public class EstimateIntrinsicDimensionality<O>
extends AbstractDistanceBasedApplication<O> {
    private static final Logging LOG = Logging.getLogger(EstimateIntrinsicDimensionality.class);
    protected double krate;
    protected double samples;
    protected IntrinsicDimensionalityEstimator<? super O> estimator;

    public EstimateIntrinsicDimensionality(InputStep inputstep, Distance<? super O> distance, IntrinsicDimensionalityEstimator<? super O> estimator, double krate, double samples) {
        super(inputstep, distance);
        this.estimator = estimator;
        this.krate = krate;
        this.samples = samples;
    }

    public void run() {
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DBIDs allids = relation.getDBIDs();
        int ssize = (int)(this.samples > 1.0 ? this.samples : Math.ceil(this.samples * (double)allids.size()));
        int kk = 1 + (int)(this.krate > 1.0 ? this.krate : Math.ceil(this.krate * (double)allids.size()));
        ModifiableDBIDs sampleids = DBIDUtil.randomSample((DBIDs)allids, (int)ssize, (RandomFactory)RandomFactory.DEFAULT);
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        DistanceQuery distq = qb.distanceQuery();
        KNNSearcher knnq = qb.kNNByDBID(kk);
        double[] idim = new double[ssize];
        int samples = 0;
        DBIDIter iter = sampleids.iter();
        while (iter.valid()) {
            idim[samples++] = this.estimator.estimate(knnq, distq, (DBIDRef)iter, kk);
            iter.advance();
        }
        double id = samples > 1 ? QuickSelect.median((double[])idim, (int)0, (int)samples) : -1.0;
        LOG.statistics((Statistic)new DoubleStatistic(EstimateIntrinsicDimensionality.class.getName() + ".intrinsic-dimensionality", id));
    }

    public static class Par<O>
    extends AbstractDistanceBasedApplication.Par<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("idist.estimator", "Estimation method for intrinsic dimensionality.");
        public static final OptionID KRATE_ID = new OptionID("idist.k", "Number of kNN (absolute or relative)");
        public static final OptionID SAMPLES_ID = new OptionID("idist.sampling", "Sample size (absolute or relative)");
        protected IntrinsicDimensionalityEstimator<? super O> estimator;
        protected double krate;
        protected double samples;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(ESTIMATOR_ID, IntrinsicDimensionalityEstimator.class, GEDEstimator.class).grab(config, x -> {
                this.estimator = x;
            });
            ((DoubleParameter)new DoubleParameter(KRATE_ID, 50.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.krate = x;
            });
            ((DoubleParameter)new DoubleParameter(SAMPLES_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.samples = x;
            });
        }

        public EstimateIntrinsicDimensionality<O> make() {
            return new EstimateIntrinsicDimensionality<O>(this.inputstep, this.distance, this.estimator, this.krate, this.samples);
        }
    }
}

