/*
 * Decompiled with CFR 0.152.
 */
package elki.application.statistics;

import elki.application.AbstractDistanceBasedApplication;
import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.MeanVariance;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import elki.workflow.InputStep;

public class RangeQuerySelectivity<V extends NumberVector>
extends AbstractDistanceBasedApplication<V> {
    private static final Logging LOG = Logging.getLogger(RangeQuerySelectivity.class);
    protected double radius;
    protected double sampling = 1.0;
    protected RandomFactory random = null;

    public RangeQuerySelectivity(InputStep inputstep, Distance<? super V> distance, double radius, double sampling, RandomFactory random) {
        super(inputstep, distance);
        this.radius = radius;
        this.sampling = sampling;
        this.random = random;
    }

    public void run() {
        Relation relation = this.inputstep.getDatabase().getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        RangeSearcher rangeQuery = new QueryBuilder(relation, this.distance).rangeByDBID(this.radius);
        DBIDs ids = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (double)this.sampling, (RandomFactory)this.random);
        MeanVariance numres = new MeanVariance();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Performing range queries", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            numres.put((double)rangeQuery.getRange((Object)iter, this.radius).size());
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        String prefix = ((Object)((Object)this)).getClass().getName();
        LOG.statistics((Statistic)new DoubleStatistic(prefix + ".mean", numres.getMean()));
        LOG.statistics((Statistic)new DoubleStatistic(prefix + ".std", numres.getSampleStddev()));
        LOG.statistics((Statistic)new DoubleStatistic(prefix + ".norm.mean", numres.getMean() / (double)relation.size()));
        LOG.statistics((Statistic)new DoubleStatistic(prefix + ".norm.std", numres.getSampleStddev() / (double)relation.size()));
        LOG.statistics((Statistic)new LongStatistic(prefix + ".samplesize", (long)ids.size()));
    }

    public static class Par<V extends NumberVector>
    extends AbstractDistanceBasedApplication.Par<V> {
        public static final OptionID RADIUS_ID = new OptionID("selectivity.radius", "Radius to use for selectivity estimation.");
        public static final OptionID SAMPLING_ID = new OptionID("selectivity.sampling", "Relative amount of object to sample.");
        public static final OptionID SEED_ID = new OptionID("selectivity.sampling-seed", "Random seed for deterministic sampling.");
        protected double radius;
        protected double sampling = 1.0;
        protected RandomFactory random = RandomFactory.DEFAULT;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((DoubleParameter)new DoubleParameter(RADIUS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.radius = x;
            });
            ((DoubleParameter)((DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).setOptional(true)).grab(config, x -> {
                this.sampling = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.random = x;
            });
        }

        public RangeQuerySelectivity<V> make() {
            return new RangeQuerySelectivity(this.inputstep, this.distance, this.radius, this.sampling, this.random);
        }
    }
}

