/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.correlation.cash;

import elki.clustering.correlation.cash.CASHIntervalSplit;
import elki.data.HyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.logging.Logging;

public class CASHInterval
extends HyperBoundingBox
implements Comparable<CASHInterval> {
    private static final Logging LOG = Logging.getLogger(CASHInterval.class);
    private static final long serialVersionUID = 1L;
    private static int ID = 0;
    private final int intervalID = ++ID;
    private int level;
    private double d_min;
    private double d_max;
    private ModifiableDBIDs ids;
    private int maxSplitDimension;
    private CASHInterval leftChild;
    private CASHInterval rightChild;
    private CASHIntervalSplit split;

    public CASHInterval() {
    }

    public CASHInterval(double[] min, double[] max, CASHIntervalSplit split, ModifiableDBIDs ids, int maxSplitDimension, int level, double d_min, double d_max) {
        super(min, max);
        this.split = split;
        this.ids = ids;
        this.maxSplitDimension = maxSplitDimension;
        this.level = level;
        this.d_min = d_min;
        this.d_max = d_max;
    }

    public ModifiableDBIDs getIDs() {
        return this.ids;
    }

    public void removeIDs(DBIDs ids2) {
        this.ids.removeDBIDs(ids2);
    }

    public int numObjects() {
        return this.ids.size();
    }

    public String toString() {
        return super.toString() + ", ids: " + this.ids.size() + ", d_min: " + this.d_min + ", d_max " + this.d_max;
    }

    public int priority() {
        return this.numObjects();
    }

    public int getMaxSplitDimension() {
        return this.maxSplitDimension;
    }

    public int getLevel() {
        return this.level;
    }

    public CASHInterval getLeftChild() {
        return this.leftChild;
    }

    public CASHInterval getRightChild() {
        return this.rightChild;
    }

    public double getD_min() {
        return this.d_min;
    }

    public double getD_max() {
        return this.d_max;
    }

    @Override
    public int compareTo(CASHInterval other) {
        if (this.equals(other)) {
            return 0;
        }
        int c = Integer.compare(this.priority(), other.priority());
        c = c == 0 ? Integer.compare(this.level, other.level) : c;
        c = c == 0 ? Integer.compare(this.maxSplitDimension, other.maxSplitDimension) : c;
        return c == 0 ? Integer.compare(other.intervalID, this.intervalID) : c;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.intervalID == ((CASHInterval)o).intervalID;
    }

    public int hashCode() {
        return this.intervalID;
    }

    public boolean hasChildren() {
        return this.leftChild != null || this.rightChild != null;
    }

    public void split() {
        if (this.hasChildren()) {
            return;
        }
        boolean issplit = this.maxSplitDimension >= this.getDimensionality() - 1;
        int childLevel = issplit ? this.level + 1 : this.level;
        int splitDim = issplit ? 0 : this.maxSplitDimension + 1;
        double splitPoint = this.getMin(splitDim) + (this.getMax(splitDim) - this.getMin(splitDim)) * 0.5;
        for (int i = 0; i < 2; ++i) {
            double[] min = SpatialUtil.getMin((SpatialComparable)this);
            double[] max = SpatialUtil.getMax((SpatialComparable)this);
            if (i == 0) {
                min[splitDim] = splitPoint;
            } else {
                max[splitDim] = splitPoint;
            }
            ModifiableDBIDs childIDs = this.split.determineIDs((DBIDs)this.getIDs(), new HyperBoundingBox(min, max), this.d_min, this.d_max);
            if (childIDs == null) continue;
            if (i == 0) {
                this.rightChild = new CASHInterval(min, max, this.split, childIDs, splitDim, childLevel, this.d_min, this.d_max);
                continue;
            }
            this.leftChild = new CASHInterval(min, max, this.split, childIDs, splitDim, childLevel, this.d_min, this.d_max);
        }
        if (LOG.isDebuggingFine()) {
            StringBuilder msg = new StringBuilder(1000).append("Child level ").append(childLevel).append(",  split Dim   ").append(splitDim);
            if (this.leftChild != null) {
                msg.append("\nleft   ").append(this.leftChild);
            }
            if (this.rightChild != null) {
                msg.append("\nright   ").append(this.rightChild);
            }
            LOG.fine((CharSequence)msg.toString());
        }
    }
}

