/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.correlation.cash;

import elki.clustering.correlation.cash.ParameterizationFunction;
import elki.data.HyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.utilities.io.FormatUtil;
import java.util.HashMap;
import java.util.Map;

public class CASHIntervalSplit {
    private static final Logging LOG = Logging.getLogger(CASHIntervalSplit.class);
    private Relation<ParameterizationFunction> database;
    private Map<HyperBoundingBox, WritableDoubleDataStore> f_minima;
    private Map<HyperBoundingBox, WritableDoubleDataStore> f_maxima;
    private int minPts;

    public CASHIntervalSplit(Relation<ParameterizationFunction> database, int minPts) {
        this.database = database;
        this.minPts = minPts;
        this.f_minima = new HashMap<HyperBoundingBox, WritableDoubleDataStore>();
        this.f_maxima = new HashMap<HyperBoundingBox, WritableDoubleDataStore>();
    }

    public ModifiableDBIDs determineIDs(DBIDs superSetIDs, HyperBoundingBox interval, double d_min, double d_max) {
        StringBuilder msg;
        StringBuilder stringBuilder = msg = LOG.isDebugging() ? new StringBuilder() : null;
        if (msg != null) {
            msg.append("interval ").append(interval);
        }
        HashSetModifiableDBIDs childIDs = DBIDUtil.newHashSet((int)superSetIDs.size());
        WritableDoubleDataStore minima = this.f_minima.get(interval);
        WritableDoubleDataStore maxima = this.f_maxima.get(interval);
        if (minima == null || maxima == null) {
            minima = DataStoreFactory.FACTORY.makeDoubleStorage(superSetIDs, 3, Double.NaN);
            this.f_minima.put(interval, minima);
            maxima = DataStoreFactory.FACTORY.makeDoubleStorage(superSetIDs, 3, Double.NaN);
            this.f_maxima.put(interval, maxima);
        }
        DBIDIter iter = superSetIDs.iter();
        while (iter.valid()) {
            double f_min = minima.doubleValue((DBIDRef)iter);
            double f_max = maxima.doubleValue((DBIDRef)iter);
            if (Double.isNaN(f_min)) {
                ParameterizationFunction f = (ParameterizationFunction)this.database.get((DBIDRef)iter);
                HyperBoundingBox minMax = f.determineAlphaMinMax(interval);
                f_min = f.function(SpatialUtil.getMin((SpatialComparable)minMax));
                minima.put((DBIDRef)iter, f_min);
                f_max = f.function(SpatialUtil.getMax((SpatialComparable)minMax));
                maxima.put((DBIDRef)iter, f_max);
            }
            if (msg != null) {
                msg.append("\n\nf_min ").append(f_min).append("\nf_max ").append(f_max).append("\nd_min ").append(d_min).append("\nd_max ").append(d_max);
            }
            if (f_min - f_max > 1.0E-10) {
                throw new IllegalArgumentException("Houston, we have a problem: f_min > f_max! \nf_min[" + FormatUtil.format((double[])SpatialUtil.centroid((SpatialComparable)interval)) + "] = " + f_min + "\nf_max[" + FormatUtil.format((double[])SpatialUtil.centroid((SpatialComparable)interval)) + "] = " + f_max + "\nf " + this.database.get((DBIDRef)iter));
            }
            if (f_min <= d_max && f_max >= d_min) {
                childIDs.add((DBIDRef)iter);
                if (msg != null) {
                    msg.append("\nid ").append(iter).append(" appended");
                }
            } else if (msg != null) {
                msg.append("\nid ").append(iter).append(" NOT appended");
            }
            iter.advance();
        }
        if (msg != null) {
            LOG.debugFine((CharSequence)msg.append("\nchildIds ").append(childIDs.size()).toString());
        }
        return childIDs.size() < this.minPts ? null : childIDs;
    }
}

