/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.subspace;

import elki.clustering.optics.CorrelationClusterOrder;
import elki.clustering.optics.GeneralizedOPTICS;
import elki.clustering.subspace.SubspaceClusteringAlgorithm;
import elki.data.BitVector;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.Subspace;
import elki.data.model.Model;
import elki.data.model.SubspaceModel;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDFactory;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.subspace.OnedimensionalDistance;
import elki.itemsetmining.APRIORI;
import elki.itemsetmining.Itemset;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.MillisTimeDuration;
import elki.logging.statistics.Statistic;
import elki.math.MathUtil;
import elki.math.linearalgebra.Centroid;
import elki.math.linearalgebra.ProjectedCentroid;
import elki.result.FrequentItemsetsResult;
import elki.result.Metadata;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.datastructures.hierarchy.Hierarchy;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.pairs.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Title(value="DiSH: Detecting Subspace cluster Hierarchies")
@Description(value="Algorithm to find hierarchical correlation clusters in subspaces.")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, I. M\u00fcller-Gorman, A. Zimek", title="Detection and Visualization of Subspace Cluster Hierarchies", booktitle="Proc. 12th Int. Conf. on Database Systems for Advanced Applications (DASFAA)", url="https://doi.org/10.1007/978-3-540-71703-4_15", bibkey="DBLP:conf/dasfaa/AchtertBKKMZ07")
public class DiSH
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(DiSH.class);
    private double epsilon;
    private int minpts;
    private Strategy strategy;

    public DiSH(double epsilon, int minpts, Strategy strategy) {
        this.epsilon = epsilon;
        this.minpts = minpts;
        this.strategy = strategy;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public Clustering<SubspaceModel> run(Relation<? extends NumberVector> relation) {
        if (this.minpts >= relation.size()) {
            throw new AbortException("Parameter minpts is chosen unreasonably large. This won't yield meaningful results.");
        }
        DiSHClusterOrder opticsResult = new Instance(relation).run();
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Compute Clusters.");
        }
        return this.computeClusters(relation, opticsResult);
    }

    private Clustering<SubspaceModel> computeClusters(Relation<? extends NumberVector> database, DiSHClusterOrder clusterOrder) {
        int dimensionality = RelationUtil.dimensionality(database);
        Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> clustersMap = this.extractClusters(database, clusterOrder);
        this.logClusterSizes("Step 1: extract clusters", dimensionality, clustersMap);
        this.checkClusters(database, (Object2ObjectMap<long[], List<ArrayModifiableDBIDs>>)clustersMap);
        this.logClusterSizes("Step 2: check clusters", dimensionality, clustersMap);
        List<Cluster<SubspaceModel>> clusters = this.sortClusters(database, (Object2ObjectMap<long[], List<ArrayModifiableDBIDs>>)clustersMap);
        if (LOG.isVerbose()) {
            StringBuilder msg = new StringBuilder("Step 3: sort clusters");
            for (Cluster<SubspaceModel> cluster : clusters) {
                msg.append('\n').append(BitsUtil.toStringLow((long[])((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), (int)dimensionality)).append(" ids ").append(cluster.size());
            }
            LOG.verbose((CharSequence)msg.toString());
        }
        Clustering clustering = new Clustering();
        Metadata.of((Object)clustering).setLongName("DiSH clustering");
        this.buildHierarchy(database, (Clustering<SubspaceModel>)clustering, clusters, dimensionality);
        if (LOG.isVerbose()) {
            StringBuilder msg = new StringBuilder("Step 4: build hierarchy");
            for (Cluster<SubspaceModel> cluster : clusters) {
                msg.append('\n').append(BitsUtil.toStringLow((long[])((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), (int)dimensionality)).append(" ids ").append(cluster.size());
                It iter = clustering.getClusterHierarchy().iterParents(cluster);
                while (iter.valid()) {
                    msg.append("\n   parent ").append(iter.get());
                    iter.advance();
                }
                iter = clustering.getClusterHierarchy().iterChildren(cluster);
                while (iter.valid()) {
                    msg.append("\n   child ").append(iter.get());
                    iter.advance();
                }
            }
            LOG.verbose((CharSequence)msg.toString());
        }
        for (Cluster<SubspaceModel> cluster : clusters) {
            if (clustering.getClusterHierarchy().numParents(cluster) != 0) continue;
            clustering.addToplevelCluster(cluster);
        }
        return clustering;
    }

    private void logClusterSizes(String m, int dimensionality, Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        if (LOG.isVerbose()) {
            StringBuilder msg = new StringBuilder(1000).append(m).append('\n');
            ObjectIterator iter = clustersMap.object2ObjectEntrySet().fastIterator();
            while (iter.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
                msg.append(BitsUtil.toStringLow((long[])((long[])entry.getKey()), (int)dimensionality)).append(" sizes:");
                for (ArrayModifiableDBIDs c : (List)entry.getValue()) {
                    msg.append(' ').append(c.size());
                }
                msg.append('\n');
            }
            LOG.verbose((CharSequence)msg.toString());
        }
    }

    private Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> extractClusters(Relation<? extends NumberVector> relation, DiSHClusterOrder clusterOrder) {
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Extract Clusters", relation.size(), LOG) : null;
        Object2ObjectOpenCustomHashMap clustersMap = new Object2ObjectOpenCustomHashMap(BitsUtil.FASTUTIL_HASH_STRATEGY);
        WritableDataStore entryToClusterMap = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, Pair.class);
        DBIDArrayIter iter = clusterOrder.iter();
        while (iter.valid()) {
            NumberVector object = (NumberVector)relation.get((DBIDRef)iter);
            long[] preferenceVector = clusterOrder.getCommonPreferenceVector((DBIDRef)iter);
            ArrayList<ArrayModifiableDBIDs> parallelClusters = (ArrayList<ArrayModifiableDBIDs>)clustersMap.get((Object)preferenceVector);
            if (parallelClusters == null) {
                parallelClusters = new ArrayList<ArrayModifiableDBIDs>();
                clustersMap.put((Object)preferenceVector, parallelClusters);
            }
            Object cluster = null;
            for (ArrayModifiableDBIDs c : parallelClusters) {
                double d;
                long[] commonPreferenceVector;
                ProjectedCentroid c_centroid = ProjectedCentroid.make((long[])preferenceVector, relation, (DBIDs)c);
                int subspaceDim = this.subspaceDimensionality(object, (NumberVector)c_centroid, preferenceVector, preferenceVector, commonPreferenceVector = BitsUtil.andCMin((long[])preferenceVector, (long[])preferenceVector));
                if (subspaceDim != clusterOrder.getCorrelationValue((DBIDRef)iter) || !((d = DiSH.weightedDistance(object, (NumberVector)c_centroid, commonPreferenceVector)) <= 2.0 * this.epsilon)) continue;
                cluster = c;
                break;
            }
            if (cluster == null) {
                cluster = DBIDUtil.newArray();
                parallelClusters.add((ArrayModifiableDBIDs)cluster);
            }
            cluster.add((DBIDRef)iter);
            entryToClusterMap.put((DBIDRef)iter, (Object)new Pair((Object)preferenceVector, cluster));
            LOG.incrementProcessed((AbstractProgress)progress);
            iter.advance();
        }
        LOG.ensureCompleted(progress);
        if (LOG.isDebuggingFiner()) {
            int dim = RelationUtil.dimensionality(relation);
            StringBuilder msg = new StringBuilder("Step 0");
            for (Map.Entry clusterList : clustersMap.entrySet()) {
                for (ArrayModifiableDBIDs c : (List)clusterList.getValue()) {
                    msg.append('\n').append(BitsUtil.toStringLow((long[])((long[])clusterList.getKey()), (int)dim)).append(" ids ").append(c.size());
                }
            }
            LOG.debugFiner((CharSequence)msg.toString());
        }
        DBIDVar cur = DBIDUtil.newVar();
        DBIDVar pre = DBIDUtil.newVar();
        for (long[] pv : clustersMap.keySet()) {
            List parallelClusters = (List)clustersMap.get((Object)pv);
            for (ArrayModifiableDBIDs cluster : parallelClusters) {
                if (cluster.isEmpty()) continue;
                cluster.assignVar(0, cur);
                clusterOrder.getPredecessor((DBIDRef)cur, pre);
                if (!pre.isSet() || DBIDUtil.equal((DBIDRef)pre, (DBIDRef)cur) || BitsUtil.equal((long[])clusterOrder.getCommonPreferenceVector((DBIDRef)pre), (long[])clusterOrder.getCommonPreferenceVector((DBIDRef)cur)) || clusterOrder.getCorrelationValue((DBIDRef)pre) < clusterOrder.getCorrelationValue((DBIDRef)cur) || clusterOrder.getReachability((DBIDRef)pre) < clusterOrder.getReachability((DBIDRef)cur)) continue;
                Pair oldCluster = (Pair)entryToClusterMap.get((DBIDRef)pre);
                ((ArrayModifiableDBIDs)oldCluster.second).remove((DBIDRef)pre);
                cluster.add((DBIDRef)pre);
                entryToClusterMap.put((DBIDRef)pre, (Object)new Pair((Object)pv, (Object)cluster));
            }
        }
        return clustersMap;
    }

    private List<Cluster<SubspaceModel>> sortClusters(Relation<? extends NumberVector> relation, Object2ObjectMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        int db_dim = RelationUtil.dimensionality(relation);
        ArrayList<Cluster<SubspaceModel>> clusters = new ArrayList<Cluster<SubspaceModel>>();
        for (long[] pv : clustersMap.keySet()) {
            List parallelClusters = (List)clustersMap.get((Object)pv);
            for (int i = 0; i < parallelClusters.size(); ++i) {
                ArrayModifiableDBIDs c = (ArrayModifiableDBIDs)parallelClusters.get(i);
                Cluster cluster = new Cluster((DBIDs)c);
                cluster.setModel((Model)new SubspaceModel(new Subspace(pv), Centroid.make(relation, (DBIDs)c).getArrayRef()));
                String subspace = BitsUtil.toStringLow((long[])((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), (int)db_dim);
                cluster.setName(parallelClusters.size() > 1 ? "Cluster_" + subspace + "_" + i : "Cluster_" + subspace);
                clusters.add((Cluster<SubspaceModel>)cluster);
            }
        }
        Collections.sort(clusters, (c1, c2) -> ((SubspaceModel)c2.getModel()).getSubspace().dimensionality() - ((SubspaceModel)c1.getModel()).getSubspace().dimensionality());
        return clusters;
    }

    private void checkClusters(Relation<? extends NumberVector> relation, Object2ObjectMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        int dimensionality = RelationUtil.dimensionality(relation);
        ArrayList<Pair> notAssigned = new ArrayList<Pair>();
        Object2ObjectOpenCustomHashMap newClustersMap = new Object2ObjectOpenCustomHashMap(BitsUtil.FASTUTIL_HASH_STRATEGY);
        Pair noise = new Pair((Object)BitsUtil.zero((int)dimensionality), (Object)DBIDUtil.newArray());
        for (long[] pv : clustersMap.keySet()) {
            List parallelClusters;
            if (BitsUtil.cardinality((long[])pv) == 0) {
                parallelClusters = (List)clustersMap.get((Object)pv);
                for (ArrayModifiableDBIDs c : parallelClusters) {
                    ((ArrayModifiableDBIDs)noise.second).addDBIDs((DBIDs)c);
                }
                continue;
            }
            parallelClusters = (List)clustersMap.get((Object)pv);
            ArrayList<ArrayModifiableDBIDs> newParallelClusters = new ArrayList<ArrayModifiableDBIDs>(parallelClusters.size());
            for (ArrayModifiableDBIDs c : parallelClusters) {
                if (!BitsUtil.isZero((long[])pv) && c.size() < this.minpts) {
                    notAssigned.add(new Pair((Object)pv, (Object)c));
                    continue;
                }
                newParallelClusters.add(c);
            }
            newClustersMap.put((Object)pv, newParallelClusters);
        }
        clustersMap.clear();
        clustersMap.putAll((Map)newClustersMap);
        for (Pair c : notAssigned) {
            Pair parent;
            if (((ArrayModifiableDBIDs)c.second).isEmpty()) continue;
            ((ArrayModifiableDBIDs)((parent = this.findParent(relation, (Pair<long[], ArrayModifiableDBIDs>)c, clustersMap)) != null ? parent : noise).second).addDBIDs((DBIDs)c.second);
        }
        ArrayList<ArrayModifiableDBIDs> noiseList = new ArrayList<ArrayModifiableDBIDs>(1);
        noiseList.add((ArrayModifiableDBIDs)noise.second);
        clustersMap.put((Object)((long[])noise.first), noiseList);
    }

    private Pair<long[], ArrayModifiableDBIDs> findParent(Relation<? extends NumberVector> relation, Pair<long[], ArrayModifiableDBIDs> child, Object2ObjectMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        ProjectedCentroid child_centroid = ProjectedCentroid.make((long[])((long[])child.first), relation, (DBIDs)((DBIDs)child.second));
        Pair result = null;
        int resultCardinality = -1;
        long[] childPV = (long[])child.first;
        int childCardinality = BitsUtil.cardinality((long[])childPV);
        block0: for (long[] parentPV : clustersMap.keySet()) {
            long[] pv;
            int parentCardinality = BitsUtil.cardinality((long[])parentPV);
            if (parentCardinality >= childCardinality || resultCardinality != -1 && parentCardinality <= resultCardinality || !BitsUtil.equal((long[])(pv = BitsUtil.andCMin((long[])childPV, (long[])parentPV)), (long[])parentPV)) continue;
            List parentList = (List)clustersMap.get((Object)parentPV);
            for (ArrayModifiableDBIDs parent : parentList) {
                ProjectedCentroid parent_centroid = ProjectedCentroid.make((long[])parentPV, relation, (DBIDs)parent);
                double d = DiSH.weightedDistance((NumberVector)child_centroid, (NumberVector)parent_centroid, parentPV);
                if (!(d <= 2.0 * this.epsilon)) continue;
                result = new Pair((Object)parentPV, (Object)parent);
                resultCardinality = parentCardinality;
                continue block0;
            }
        }
        return result;
    }

    private void buildHierarchy(Relation<? extends NumberVector> database, Clustering<SubspaceModel> clustering, List<Cluster<SubspaceModel>> clusters, int dimensionality) {
        StringBuilder msg = LOG.isDebugging() ? new StringBuilder() : null;
        int db_dim = RelationUtil.dimensionality(database);
        Hierarchy hier = clustering.getClusterHierarchy();
        for (int i = 0; i < clusters.size() - 1; ++i) {
            Cluster<SubspaceModel> c_i = clusters.get(i);
            Subspace s_i = ((SubspaceModel)c_i.getModel()).getSubspace();
            int subspaceDim_i = dimensionality - s_i.dimensionality();
            ProjectedCentroid ci_centroid = ProjectedCentroid.make((long[])s_i.getDimensions(), database, (DBIDs)c_i.getIDs());
            long[] pv1 = s_i.getDimensions();
            for (int j = i + 1; j < clusters.size(); ++j) {
                Cluster<SubspaceModel> c_j = clusters.get(j);
                Subspace s_j = ((SubspaceModel)c_j.getModel()).getSubspace();
                int subspaceDim_j = dimensionality - s_j.dimensionality();
                if (subspaceDim_i >= subspaceDim_j) continue;
                if (msg != null) {
                    msg.append("\n l_i=").append(subspaceDim_i).append(" pv_i=[").append(BitsUtil.toStringLow((long[])s_i.getDimensions(), (int)db_dim)).append(']').append("\n l_j=").append(subspaceDim_j).append(" pv_j=[").append(BitsUtil.toStringLow((long[])s_j.getDimensions(), (int)db_dim)).append(']');
                }
                if (s_j.dimensionality() == 0) {
                    if (hier.numParents(c_i) != 0) continue;
                    clustering.addChildCluster(c_j, c_i);
                    if (msg == null) continue;
                    msg.append("\n [").append(BitsUtil.toStringLow((long[])s_j.getDimensions(), (int)db_dim)).append("] is parent of [").append(BitsUtil.toStringLow((long[])s_i.getDimensions(), (int)db_dim)).append(']');
                    continue;
                }
                ProjectedCentroid cj_centroid = ProjectedCentroid.make((long[])((SubspaceModel)c_j.getModel()).getDimensions(), database, (DBIDs)c_j.getIDs());
                long[] pv2 = s_j.getDimensions();
                long[] commonPreferenceVector = BitsUtil.andCMin((long[])pv1, (long[])pv2);
                int subspaceDim = this.subspaceDimensionality((NumberVector)ci_centroid, (NumberVector)cj_centroid, pv1, pv2, commonPreferenceVector);
                double d = DiSH.weightedDistance((NumberVector)ci_centroid, (NumberVector)cj_centroid, commonPreferenceVector);
                if (msg != null) {
                    msg.append("\n dist = ").append(subspaceDim);
                }
                if (subspaceDim != subspaceDim_j) continue;
                if (msg != null) {
                    msg.append("\n d = ").append(d);
                }
                if (d > 2.0 * this.epsilon) {
                    throw new IllegalStateException("Should never happen: d = " + d + " > 2*" + this.epsilon);
                }
                if (hier.numParents(c_i) != 0 && this.isParent(database, c_j, (It<Cluster<SubspaceModel>>)hier.iterParents(c_i), db_dim)) continue;
                clustering.addChildCluster(c_j, c_i);
                if (msg == null) continue;
                msg.append("\n [").append(BitsUtil.toStringLow((long[])s_j.getDimensions(), (int)db_dim)).append("] is parent of [").append(BitsUtil.toStringLow((long[])s_i.getDimensions(), (int)db_dim)).append(']');
            }
        }
        if (msg != null) {
            LOG.debug((CharSequence)msg.toString());
        }
    }

    private boolean isParent(Relation<? extends NumberVector> relation, Cluster<SubspaceModel> parent, It<Cluster<SubspaceModel>> iter, int db_dim) {
        Subspace s_p = ((SubspaceModel)parent.getModel()).getSubspace();
        ProjectedCentroid parent_centroid = ProjectedCentroid.make((long[])s_p.getDimensions(), relation, (DBIDs)parent.getIDs());
        int subspaceDim_parent = db_dim - s_p.dimensionality();
        while (iter.valid()) {
            Cluster child = (Cluster)iter.get();
            Subspace s_c = ((SubspaceModel)child.getModel()).getSubspace();
            ProjectedCentroid child_centroid = ProjectedCentroid.make((long[])s_c.getDimensions(), relation, (DBIDs)child.getIDs());
            long[] commonPreferenceVector = BitsUtil.andCMin((long[])s_p.getDimensions(), (long[])s_c.getDimensions());
            int subspaceDim = this.subspaceDimensionality((NumberVector)parent_centroid, (NumberVector)child_centroid, s_p.getDimensions(), s_c.getDimensions(), commonPreferenceVector);
            if (subspaceDim == subspaceDim_parent) {
                return true;
            }
            iter.advance();
        }
        return false;
    }

    private int subspaceDimensionality(NumberVector v1, NumberVector v2, long[] pv1, long[] pv2, long[] commonPreferenceVector) {
        double d;
        int subspaceDim = v1.getDimensionality() - BitsUtil.cardinality((long[])commonPreferenceVector);
        if ((BitsUtil.equal((long[])commonPreferenceVector, (long[])pv1) || BitsUtil.equal((long[])commonPreferenceVector, (long[])pv2)) && (d = DiSH.weightedDistance(v1, v2, commonPreferenceVector)) > 2.0 * this.epsilon) {
            ++subspaceDim;
        }
        return subspaceDim;
    }

    protected static double weightedDistance(NumberVector v1, NumberVector v2, long[] weightVector) {
        double sqrDist = 0.0;
        int i = BitsUtil.nextSetBit((long[])weightVector, (int)0);
        while (i >= 0) {
            double manhattanI = v1.doubleValue(i) - v2.doubleValue(i);
            sqrDist += manhattanI * manhattanI;
            i = BitsUtil.nextSetBit((long[])weightVector, (int)(i + 1));
        }
        return Math.sqrt(sqrDist);
    }

    public static class Par
    implements Parameterizer {
        public static final double DEFAULT_EPSILON = 0.001;
        public static final OptionID EPSILON_ID = new OptionID("dish.epsilon", "A comma separated list of positive doubles specifying the maximum radius of the neighborhood to be considered in each dimension for determination of the preference vector (default is 0.001 in each dimension). If only one value is specified, this value will be used for each dimension.");
        public static final OptionID MINPTS_ID = new OptionID("dish.minpts", "Positive threshold for minumum numbers of points in the epsilon-neighborhood of a point. The value of the preference vector in dimension d_i is set to 1 if the epsilon neighborhood contains more than dish.minpts points and the following condition holds: for all dimensions d_j: |neighbors(d_i) intersection neighbors(d_j)| >= dish.minpts.");
        public static final Strategy DEFAULT_STRATEGY = Strategy.MAX_INTERSECTION;
        public static final OptionID STRATEGY_ID = new OptionID("dish.strategy", "The strategy for determination of the preference vector, available strategies are: [" + (Object)((Object)Strategy.APRIORI) + "| " + (Object)((Object)Strategy.MAX_INTERSECTION) + "](default is " + (Object)((Object)DEFAULT_STRATEGY) + ")");
        public static final OptionID MU_ID = new OptionID("dish.mu", "The minimum number of points as a smoothing factor to avoid the single-link-effekt.");
        protected double epsilon;
        protected int minpts;
        protected Strategy strategy;

        public void configure(Parameterization config) {
            ((DoubleParameter)new DoubleParameter(EPSILON_ID, 0.001).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.epsilon = x;
            });
            ((IntParameter)new IntParameter(MU_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minpts = x;
            });
            new EnumParameter(STRATEGY_ID, Strategy.class, (Enum)DEFAULT_STRATEGY).grab(config, x -> {
                this.strategy = x;
            });
        }

        public DiSH make() {
            return new DiSH(this.epsilon, this.minpts, this.strategy);
        }
    }

    public static class DiSHClusterOrder
    extends CorrelationClusterOrder {
        private WritableDataStore<long[]> commonPreferenceVectors;

        public DiSHClusterOrder(ArrayModifiableDBIDs ids, WritableDoubleDataStore reachability, WritableDBIDDataStore predecessor, WritableIntegerDataStore corrdim, WritableDataStore<long[]> commonPreferenceVectors) {
            super(ids, reachability, predecessor, corrdim);
            this.commonPreferenceVectors = commonPreferenceVectors;
        }

        public long[] getCommonPreferenceVector(DBIDRef id) {
            return (long[])this.commonPreferenceVectors.get(id);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<DiSHClusterOrder> {
        private Relation<? extends NumberVector> relation;
        private ArrayModifiableDBIDs clusterOrder;
        private WritableIntegerDataStore correlationValue;
        private WritableDataStore<long[]> commonPreferenceVectors;
        private ArrayModifiableDBIDs tmpIds;
        private WritableIntegerDataStore tmpCorrelation;
        private WritableDoubleDataStore tmpDistance;
        Comparator<DBIDRef> tmpcomp;
        protected WritableDataStore<long[]> preferenceVectors;
        private WritableDataStore<long[]> tmpPreferenceVectors;

        public Instance(Relation<? extends NumberVector> relation) {
            super(relation.getDBIDs());
            this.tmpcomp = new Sorter();
            DBIDs ids = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray((int)ids.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)30, (int)Integer.MAX_VALUE);
            this.commonPreferenceVectors = DataStoreUtil.makeStorage((DBIDs)ids, (int)3, long[].class);
            this.tmpIds = DBIDUtil.newArray((DBIDs)ids);
            this.tmpCorrelation = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3);
            this.tmpDistance = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
            this.tmpPreferenceVectors = DataStoreUtil.makeStorage((DBIDs)ids, (int)3, long[].class);
        }

        public DiSHClusterOrder run() {
            this.preferenceVectors = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)3, long[].class);
            MillisTimeDuration dur = new MillisTimeDuration(((Object)((Object)this)).getClass() + ".preprocessing-time").begin();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Preprocessing preference vector", this.relation.size(), LOG) : null;
            int dim = RelationUtil.dimensionality(this.relation);
            ArrayList<RangeSearcher> rangeQueries = new ArrayList<RangeSearcher>(dim);
            for (int d = 0; d < dim; ++d) {
                rangeQueries.add(new QueryBuilder(this.relation, (Distance)new OnedimensionalDistance(d)).rangeByDBID(DiSH.this.epsilon));
            }
            StringBuilder msg = LOG.isDebugging() ? new StringBuilder() : null;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int d;
                if (msg != null) {
                    msg.setLength(0);
                    msg.append("\nid = ").append(DBIDUtil.toString((DBIDRef)it));
                }
                ModifiableDBIDs[] allNeighbors = new ModifiableDBIDs[dim];
                for (d = 0; d < dim; ++d) {
                    allNeighbors[d] = DBIDUtil.newHashSet((DBIDs)((RangeSearcher)rangeQueries.get(d)).getRange((Object)it, DiSH.this.epsilon));
                }
                if (msg != null) {
                    for (d = 0; d < dim; ++d) {
                        msg.append("\n neighbors [").append(d).append(']').append(" (").append(allNeighbors[d].size()).append(") = ").append(allNeighbors[d]);
                    }
                }
                this.preferenceVectors.put((DBIDRef)it, (Object)this.determinePreferenceVector(allNeighbors, msg));
                if (msg != null) {
                    LOG.debugFine((CharSequence)msg.toString());
                }
                LOG.incrementProcessed((AbstractProgress)progress);
                it.advance();
            }
            LOG.ensureCompleted(progress);
            LOG.statistics((Statistic)dur.end());
            return (DiSHClusterOrder)((Object)super.run());
        }

        private long[] determinePreferenceVector(ModifiableDBIDs[] neighborIDs, StringBuilder msg) {
            return DiSH.this.strategy == Strategy.APRIORI ? this.determinePreferenceVectorByApriori(neighborIDs, msg) : this.determinePreferenceVectorByMaxIntersection(neighborIDs, msg);
        }

        private long[] determinePreferenceVectorByApriori(ModifiableDBIDs[] neighborIDs, StringBuilder msg) {
            int dimensionality = neighborIDs.length;
            ArrayList<BitVector> bvs = new ArrayList<BitVector>(this.relation.size());
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                long[] bits = BitsUtil.zero((int)dimensionality);
                boolean allFalse = true;
                for (int d = 0; d < dimensionality; ++d) {
                    if (!neighborIDs[d].contains((DBIDRef)it)) continue;
                    BitsUtil.setI((long[])bits, (int)d);
                    allFalse = false;
                }
                if (!allFalse) {
                    bvs.add(new BitVector(bits, dimensionality));
                }
                it.advance();
            }
            VectorFieldTypeInformation bitmeta = VectorFieldTypeInformation.typeRequest(BitVector.class, (int)dimensionality, (int)dimensionality);
            DBIDRange vids = DBIDFactory.FACTORY.generateStaticDBIDRange(0, bvs.size());
            MaterializedRelation bitvectorrel = new MaterializedRelation((SimpleTypeInformation)bitmeta, (DBIDs)vids);
            DBIDArrayIter it2 = vids.iter();
            while (it2.valid()) {
                bitvectorrel.insert((DBIDRef)it2, (Object)((BitVector)bvs.get(it2.getOffset())));
                it2.advance();
            }
            APRIORI apriori = new APRIORI((double)DiSH.this.minpts);
            FrequentItemsetsResult aprioriResult = apriori.run((Relation)bitvectorrel);
            List frequentItemsets = aprioriResult.getItemsets();
            if (msg != null) {
                msg.append("\n Frequent itemsets: ").append(frequentItemsets);
            }
            int maxSupport = 0;
            int maxCardinality = 0;
            long[] preferenceVector = BitsUtil.zero((int)dimensionality);
            for (Itemset itemset : frequentItemsets) {
                if (maxCardinality >= itemset.length() && (maxCardinality != itemset.length() || maxSupport != itemset.getSupport())) continue;
                preferenceVector = Itemset.toBitset((Itemset)itemset, (long[])BitsUtil.zero((int)dimensionality));
                maxCardinality = itemset.length();
                maxSupport = itemset.getSupport();
            }
            if (msg != null) {
                LOG.debugFine((CharSequence)msg.append("\n preference ").append(BitsUtil.toStringLow((long[])preferenceVector, (int)dimensionality)).append('\n').toString());
            }
            return preferenceVector;
        }

        private long[] determinePreferenceVectorByMaxIntersection(ModifiableDBIDs[] neighborIDs, StringBuilder msg) {
            int i;
            int dimensionality = neighborIDs.length;
            long[] preferenceVector = BitsUtil.zero((int)dimensionality);
            HashMap<Integer, ModifiableDBIDs> candidates = new HashMap<Integer, ModifiableDBIDs>(dimensionality);
            for (i = 0; i < dimensionality; ++i) {
                ModifiableDBIDs s_i = neighborIDs[i];
                if (s_i.size() <= DiSH.this.minpts) continue;
                candidates.put(i, s_i);
            }
            if (msg != null) {
                msg.append("\n candidates ").append(candidates.keySet());
            }
            if (!candidates.isEmpty()) {
                i = this.max(candidates);
                ModifiableDBIDs intersection = (ModifiableDBIDs)candidates.remove(i);
                BitsUtil.setI((long[])preferenceVector, (int)i);
                while (!candidates.isEmpty()) {
                    i = this.maxIntersection(candidates, intersection);
                    candidates.remove(i);
                    if (intersection.size() < DiSH.this.minpts) break;
                    BitsUtil.setI((long[])preferenceVector, (int)i);
                }
            }
            if (msg != null) {
                msg.append("\n preference ").append(BitsUtil.toStringLow((long[])preferenceVector, (int)dimensionality));
                LOG.debug((CharSequence)msg.toString());
            }
            return preferenceVector;
        }

        private int max(Map<Integer, ModifiableDBIDs> candidates) {
            int maxDim = -1;
            int size = -1;
            for (Integer nextDim : candidates.keySet()) {
                int nextSet = candidates.get(nextDim).size();
                if (size >= nextSet) continue;
                size = nextSet;
                maxDim = nextDim;
            }
            return maxDim;
        }

        private int maxIntersection(Map<Integer, ModifiableDBIDs> candidates, ModifiableDBIDs set) {
            int maxDim = -1;
            ModifiableDBIDs maxIntersection = null;
            for (Integer nextDim : candidates.keySet()) {
                DBIDs nextSet = (DBIDs)candidates.get(nextDim);
                ModifiableDBIDs nextIntersection = DBIDUtil.intersection((DBIDs)set, (DBIDs)nextSet);
                if (maxDim >= 0 && maxIntersection.size() >= nextIntersection.size()) continue;
                maxIntersection = nextIntersection;
                maxDim = nextDim;
            }
            if (maxDim >= 0) {
                set.clear().addDBIDs(maxIntersection);
            }
            return maxDim;
        }

        protected DiSHClusterOrder buildResult() {
            DiSHClusterOrder result = new DiSHClusterOrder(this.clusterOrder, this.reachability, this.predecessor, this.correlationValue, this.commonPreferenceVectors);
            Metadata.of((Object)((Object)result)).setLongName("DiSH Cluster Order");
            return result;
        }

        protected void initialDBID(DBIDRef id) {
            this.correlationValue.put(id, Integer.MAX_VALUE);
            this.commonPreferenceVectors.put(id, (Object)new long[0]);
        }

        protected void expandDBID(DBIDRef id) {
            this.clusterOrder.add(id);
            long[] pv1 = (long[])this.preferenceVectors.get(id);
            NumberVector dv1 = (NumberVector)this.relation.get(id);
            int dim = dv1.getDimensionality();
            long[] ones = BitsUtil.ones((int)dim);
            long[] inverseCommonPreferenceVector = BitsUtil.ones((int)dim);
            DBIDArrayMIter iter = this.tmpIds.iter();
            while (iter.valid()) {
                double d;
                long[] pv2 = (long[])this.preferenceVectors.get((DBIDRef)iter);
                NumberVector dv2 = (NumberVector)this.relation.get((DBIDRef)iter);
                long[] commonPreferenceVector = BitsUtil.andCMin((long[])pv1, (long[])pv2);
                int subspaceDim = dim - BitsUtil.cardinality((long[])commonPreferenceVector);
                if ((BitsUtil.equal((long[])commonPreferenceVector, (long[])pv1) || BitsUtil.equal((long[])commonPreferenceVector, (long[])pv2)) && (d = DiSH.weightedDistance(dv1, dv2, commonPreferenceVector)) > 2.0 * DiSH.this.epsilon) {
                    ++subspaceDim;
                }
                System.arraycopy(ones, 0, inverseCommonPreferenceVector, 0, ones.length);
                BitsUtil.xorI((long[])inverseCommonPreferenceVector, (long[])commonPreferenceVector);
                double orthogonalDistance = DiSH.weightedDistance(dv1, dv2, inverseCommonPreferenceVector);
                this.tmpCorrelation.put((DBIDRef)iter, subspaceDim);
                this.tmpDistance.put((DBIDRef)iter, orthogonalDistance);
                this.tmpPreferenceVectors.put((DBIDRef)iter, (Object)commonPreferenceVector);
                iter.advance();
            }
            this.tmpIds.sort(this.tmpcomp);
            double coredist = this.tmpDistance.doubleValue((DBIDRef)iter.seek(DiSH.this.minpts - 1));
            iter.seek(0);
            while (iter.valid()) {
                int curcorr;
                int prevcorr;
                if (!this.processedIDs.contains((DBIDRef)iter) && (prevcorr = this.correlationValue.intValue((DBIDRef)iter)) >= (curcorr = this.tmpCorrelation.intValue((DBIDRef)iter))) {
                    double prevdist;
                    double currdist = MathUtil.max((double)this.tmpDistance.doubleValue((DBIDRef)iter), (double)coredist);
                    if (prevcorr != curcorr || !((prevdist = this.reachability.doubleValue((DBIDRef)iter)) <= currdist)) {
                        this.correlationValue.putInt((DBIDRef)iter, curcorr);
                        this.reachability.putDouble((DBIDRef)iter, currdist);
                        this.predecessor.putDBID((DBIDRef)iter, id);
                        this.commonPreferenceVectors.put((DBIDRef)iter, (Object)((long[])this.tmpPreferenceVectors.get((DBIDRef)iter)));
                        if (prevcorr == Integer.MAX_VALUE) {
                            this.candidates.add((DBIDRef)iter);
                        }
                    }
                }
                iter.advance();
            }
        }

        public int compare(DBIDRef o1, DBIDRef o2) {
            int c2;
            int c1 = this.correlationValue.intValue(o1);
            return c1 < (c2 = this.correlationValue.intValue(o2)) ? -1 : (c1 > c2 ? 1 : super.compare(o1, o2));
        }

        protected Logging getLogger() {
            return LOG;
        }

        private final class Sorter
        implements Comparator<DBIDRef> {
            private Sorter() {
            }

            @Override
            public int compare(DBIDRef o1, DBIDRef o2) {
                int c2;
                int c1 = Instance.this.tmpCorrelation.intValue(o1);
                return c1 < (c2 = Instance.this.tmpCorrelation.intValue(o2)) ? -1 : (c1 > c2 ? 1 : Double.compare(Instance.this.tmpDistance.doubleValue(o1), Instance.this.tmpDistance.doubleValue(o2)));
            }
        }
    }

    public static enum Strategy {
        APRIORI,
        MAX_INTERSECTION;

    }
}

