/*
 * Decompiled with CFR 0.152.
 */
package elki.data.model;

import elki.data.NumberVector;
import elki.data.model.Model;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.datasource.filter.normalization.NonNumericFeaturesException;
import elki.datasource.filter.normalization.Normalization;
import elki.logging.LoggingUtil;
import elki.math.linearalgebra.LinearEquationSystem;
import elki.math.linearalgebra.VMath;
import elki.result.textwriter.TextWriteable;
import elki.result.textwriter.TextWriterStream;
import java.text.NumberFormat;
import java.util.Locale;

public class CorrelationAnalysisSolution
implements TextWriteable,
Model {
    private static final double[] EMPTY_VECTOR = new double[0];
    private LinearEquationSystem linearEquationSystem;
    private NumberFormat nf;
    private int correlationDimensionality;
    private final double standardDeviation;
    private final double[][] weakEigenvectors;
    private final double[][] strongEigenvectors;
    private final double[][] similarityMatrix;
    private final double[] centroid;

    public CorrelationAnalysisSolution(LinearEquationSystem solution, Relation<? extends NumberVector> db, double[][] strongEigenvectors, double[][] weakEigenvectors, double[][] similarityMatrix, double[] centroid) {
        this(solution, db, strongEigenvectors, weakEigenvectors, similarityMatrix, centroid, NumberFormat.getInstance(Locale.US));
    }

    public CorrelationAnalysisSolution(LinearEquationSystem solution, Relation<? extends NumberVector> db, double[][] strongEigenvectors, double[][] weakEigenvectors, double[][] similarityMatrix, double[] centroid, NumberFormat nf) {
        this.linearEquationSystem = solution;
        this.correlationDimensionality = strongEigenvectors[0].length;
        this.strongEigenvectors = strongEigenvectors;
        this.weakEigenvectors = weakEigenvectors;
        this.similarityMatrix = similarityMatrix;
        this.centroid = centroid;
        this.nf = nf;
        double variance = 0.0;
        DBIDs ids = db.getDBIDs();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            variance += this.squaredDistance((NumberVector)db.get((DBIDRef)iter));
            iter.advance();
        }
        this.standardDeviation = Math.sqrt(variance / (double)ids.size());
    }

    public LinearEquationSystem getNormalizedLinearEquationSystem(Normalization<?> normalization) throws NonNumericFeaturesException {
        if (normalization != null) {
            LinearEquationSystem lq = normalization.transform(this.linearEquationSystem);
            lq.solveByTotalPivotSearch();
            return lq;
        }
        return this.linearEquationSystem;
    }

    public int getCorrelationDimensionality() {
        return this.correlationDimensionality;
    }

    public double squaredDistance(NumberVector p) {
        double[] p_minus_a = VMath.minusEquals((double[])p.toArray(), (double[])this.centroid);
        return VMath.squareSum((double[])VMath.minusEquals((double[])p_minus_a, (double[])VMath.times((double[][])this.strongEigenvectors, (double[])VMath.transposeTimes((double[][])this.strongEigenvectors, (double[])p_minus_a))));
    }

    public double[] errorVector(NumberVector p) {
        return this.weakEigenvectors.length > 0 ? VMath.times((double[][])this.weakEigenvectors, (double[])VMath.transposeTimes((double[][])this.weakEigenvectors, (double[])VMath.minusEquals((double[])p.toArray(), (double[])this.centroid))) : EMPTY_VECTOR;
    }

    public double[] dataVector(NumberVector p) {
        return this.strongEigenvectors.length > 0 ? VMath.times((double[][])this.strongEigenvectors, (double[])VMath.transposeTimes((double[][])this.strongEigenvectors, (double[])VMath.minusEquals((double[])p.toArray(), (double[])this.centroid))) : EMPTY_VECTOR;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double[][] getStrongEigenvectors() {
        return this.strongEigenvectors;
    }

    public double[][] getWeakEigenvectors() {
        return this.weakEigenvectors;
    }

    public double[][] getSimilarityMatrix() {
        return this.similarityMatrix;
    }

    public double[] getCentroid() {
        return this.centroid;
    }

    public void writeToText(TextWriterStream out, String label) {
        if (label != null) {
            out.commentPrintLn((CharSequence)label);
        }
        out.commentPrintLn((CharSequence)("Model class: " + this.getClass().getName()));
        try {
            if (this.getNormalizedLinearEquationSystem(null) != null) {
                LinearEquationSystem lq = this.getNormalizedLinearEquationSystem(null);
                out.commentPrint((CharSequence)"Linear Equation System: ");
                out.commentPrintLn((CharSequence)lq.equationsToString(this.nf));
            }
        }
        catch (NonNumericFeaturesException e) {
            LoggingUtil.exception((Throwable)e);
        }
    }

    public String getLongName() {
        return "Correlation Analysis Solution";
    }
}

