/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.trivial.ByLabelClustering;
import elki.clustering.trivial.ByLabelOrAllInOneClustering;
import elki.clustering.trivial.ReferenceClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.type.NoSupportedDataTypeException;
import elki.database.Database;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.EvaluateClustering;
import elki.evaluation.outlier.ComputeOutlierHistogram;
import elki.evaluation.outlier.OutlierPrecisionAtKCurve;
import elki.evaluation.outlier.OutlierPrecisionRecallCurve;
import elki.evaluation.outlier.OutlierPrecisionRecallGainCurve;
import elki.evaluation.outlier.OutlierROCCurve;
import elki.evaluation.outlier.OutlierRankingEvaluation;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.scaling.LinearScaling;
import elki.utilities.scaling.ScalingFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class AutomaticEvaluation
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(AutomaticEvaluation.class);

    public void processNewResult(Object newResult) {
        this.autoEvaluateClusterings(newResult);
        this.autoEvaluateOutliers(newResult);
    }

    protected void autoEvaluateOutliers(Object newResult) {
        ArrayList outliers = ResultUtil.filterResults((Object)newResult, OutlierResult.class);
        if (LOG.isDebuggingFinest() || LOG.isDebugging() && !outliers.isEmpty()) {
            LOG.debug((CharSequence)("Number of new outlier results: " + outliers.size()));
        }
        if (!outliers.isEmpty()) {
            Database db = ResultUtil.findDatabase((Object)newResult);
            AutomaticEvaluation.ensureClusteringResult(db);
            ArrayList clusterings = ResultUtil.filterResults((Object)db, Clustering.class);
            if (clusterings.isEmpty()) {
                LOG.warning((CharSequence)"Could not find a clustering result, even after running 'ensureClusteringResult'?!?");
                return;
            }
            Clustering basec = (Clustering)clusterings.iterator().next();
            int min = Integer.MAX_VALUE;
            int total = 0;
            String label = null;
            if (basec.getAllClusters().size() > 1) {
                for (Cluster c : basec.getAllClusters()) {
                    int csize = c.getIDs().size();
                    total += csize;
                    if (csize >= min) continue;
                    min = csize;
                    label = c.getName();
                }
            }
            if (label == null) {
                LOG.warning((CharSequence)"Could not evaluate outlier results, as I could not find a minority label.");
                return;
            }
            if (min == 1) {
                LOG.warning((CharSequence)"The minority class label had a single object. Try using 'ClassLabelFilter' to identify the class label column.");
            }
            if ((double)min > 0.05 * (double)total) {
                LOG.warning((CharSequence)("The minority class I discovered (labeled '" + label + "') has " + (double)min * 100.0 / (double)total + "% of objects. Outlier classes should be more rare!"));
            }
            LOG.verbose((CharSequence)("Evaluating using minority class: " + label));
            Pattern pat = Pattern.compile("^" + Pattern.quote(label) + "$");
            new OutlierRankingEvaluation(pat).processNewResult(newResult);
            new OutlierROCCurve(pat).processNewResult(newResult);
            new OutlierPrecisionAtKCurve(pat, min << 1).processNewResult(newResult);
            new OutlierPrecisionRecallCurve(pat).processNewResult(newResult);
            new OutlierPrecisionRecallGainCurve(pat).processNewResult(newResult);
            new ComputeOutlierHistogram(pat, 50, (ScalingFunction)new LinearScaling(), false).processNewResult(newResult);
        }
    }

    protected void autoEvaluateClusterings(Object newResult) {
        ArrayList clusterings = ResultUtil.filterResults((Object)newResult, Clustering.class);
        if (LOG.isDebuggingFinest() || LOG.isDebugging() && !clusterings.isEmpty()) {
            LOG.debug((CharSequence)("Number of new clustering results: " + clusterings.size()));
        }
        Iterator c = clusterings.iterator();
        while (c.hasNext()) {
            if (!(c.next() instanceof ReferenceClustering)) continue;
            c.remove();
        }
        if (!clusterings.isEmpty()) {
            try {
                new EvaluateClustering((ClusteringAlgorithm)new ByLabelClustering(), false, true).processNewResult(newResult);
            }
            catch (NoSupportedDataTypeException noSupportedDataTypeException) {
                // empty catch block
            }
        }
    }

    public static void ensureClusteringResult(Database db) {
        if (!Metadata.hierarchyOf((Object)db).iterDescendantsSelf().filter(Clustering.class).valid()) {
            Metadata.hierarchyOf((Object)db).addChild((Object)new ByLabelOrAllInOneClustering().autorun(db));
        }
    }

    public static class Par
    implements Parameterizer {
        public AutomaticEvaluation make() {
            return new AutomaticEvaluation();
        }
    }
}

