/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.index;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.evaluation.Evaluator;
import elki.index.tree.Node;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.math.MeanVariance;
import elki.result.CollectionResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class IndexPurity
implements Evaluator {
    public void processNewResult(Object newResult) {
        Database database = ResultUtil.findDatabase((Object)newResult);
        ArrayList indexes = ResultUtil.filterResults((Object)newResult, AbstractRStarTree.class);
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        Relation lblrel = DatabaseUtil.guessLabelRepresentation((Database)database);
        for (AbstractRStarTree index : indexes) {
            List leaves = index.getLeaves();
            MeanVariance mv = new MeanVariance();
            for (SpatialEntry e : leaves) {
                SpatialDirectoryEntry leaf = (SpatialDirectoryEntry)e;
                Node n = index.getNode(leaf.getPageID());
                int total = n.getNumEntries();
                Object2IntOpenHashMap map = new Object2IntOpenHashMap(total);
                for (int i = 0; i < total; ++i) {
                    DBID id = ((SpatialPointLeafEntry)n.getEntry(i)).getDBID();
                    map.addTo((Object)((String)lblrel.get((DBIDRef)id)), 1);
                }
                double gini = 0.0;
                IntIterator it = map.values().iterator();
                while (it.hasNext()) {
                    double rel = (double)it.nextInt() / (double)total;
                    gini += rel * rel;
                }
                mv.put(gini);
            }
            ArrayList<double[]> col = new ArrayList<double[]>();
            col.add(new double[]{mv.getMean(), mv.getSampleStddev()});
            CollectionResult result = new CollectionResult(col);
            Metadata.of((Object)result).setLongName("Gini coefficient of index");
            Metadata.hierarchyOf((Object)index).addChild((Object)result);
        }
    }
}

