/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.DoubleRelation;
import elki.evaluation.Evaluator;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.scaling.IdentityScaling;
import elki.utilities.scaling.ScalingFunction;
import elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;
import java.util.Arrays;

public class OutlierThresholdClustering
implements Evaluator {
    ScalingFunction scaling = null;
    double[] threshold;

    public OutlierThresholdClustering(ScalingFunction scaling, double[] threshold) {
        this.scaling = scaling;
        this.threshold = threshold;
        Arrays.sort(this.threshold);
    }

    public void processNewResult(Object newResult) {
        ArrayList ors = ResultUtil.filterResults((Object)newResult, OutlierResult.class);
        for (OutlierResult or : ors) {
            Metadata.hierarchyOf((Object)or).addChild(this.split(or));
        }
    }

    private Clustering<Model> split(OutlierResult or) {
        DoubleRelation scores = or.getScores();
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        ArrayList<HashSetModifiableDBIDs> idlists = new ArrayList<HashSetModifiableDBIDs>(this.threshold.length + 1);
        for (int i = 0; i <= this.threshold.length; ++i) {
            idlists.add(DBIDUtil.newHashSet());
        }
        DBIDIter iter = scores.getDBIDs().iter();
        while (iter.valid()) {
            int i;
            double score = scores.doubleValue((DBIDRef)iter);
            if (this.scaling != null) {
                score = this.scaling.getScaled(score);
            }
            for (i = 0; i < this.threshold.length && !(score < this.threshold[i]); ++i) {
            }
            ((ModifiableDBIDs)idlists.get(i)).add((DBIDRef)iter);
            iter.advance();
        }
        Clustering result = new Clustering();
        Metadata.of((Object)result).setLongName("Outlier threshold clustering");
        for (int i = 0; i <= this.threshold.length; ++i) {
            String name = i == 0 ? "Inlier" : "Outlier_" + this.threshold[i - 1];
            result.addToplevelCluster(new Cluster(name, (DBIDs)idlists.get(i), i > 0));
        }
        return result;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SCALING_ID = new OptionID("thresholdclust.scaling", "Class to use as scaling function.");
        public static final OptionID THRESHOLD_ID = new OptionID("thresholdclust.threshold", "Threshold(s) to apply.");
        ScalingFunction scaling = null;
        double[] threshold;

        public void configure(Parameterization config) {
            new ObjectParameter(SCALING_ID, ScalingFunction.class, IdentityScaling.class).grab(config, x -> {
                this.scaling = x;
            });
            new DoubleListParameter(THRESHOLD_ID).grab(config, x -> {
                this.threshold = (double[])x.clone();
            });
        }

        public OutlierThresholdClustering make() {
            return new OutlierThresholdClustering(this.scaling, this.threshold);
        }
    }
}

