/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.similaritymatrix;

import elki.Algorithm;
import elki.database.Database;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.logging.Logging;
import elki.logging.LoggingUtil;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.PixmapResult;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.scaling.LinearScaling;
import elki.utilities.scaling.ScalingFunction;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ComputeSimilarityMatrixImage<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(ComputeSimilarityMatrixImage.class);
    private Distance<? super O> distance;
    private ScalingFunction scaling;
    private boolean skipzero = false;

    public ComputeSimilarityMatrixImage(Distance<? super O> distance, ScalingFunction scaling, boolean skipzero) {
        this.distance = distance;
        this.scaling = scaling;
        this.skipzero = skipzero;
    }

    private SimilarityMatrix computeSimilarityMatrixImage(Relation<O> relation, DBIDIter iter) {
        ArrayModifiableDBIDs order = DBIDUtil.newArray((int)relation.size());
        while (iter.valid()) {
            order.add((DBIDRef)iter);
            iter.advance();
        }
        if (order.size() != relation.size()) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        DistanceQuery dq = this.distance.instantiate(relation);
        int size = order.size();
        int ltotal = 2 * size;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Similarity Matrix Image", ltotal, LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDArrayMIter id1 = order.iter();
        DBIDArrayMIter id2 = order.iter();
        while (id1.valid()) {
            id2.seek(id1.getOffset());
            while (id2.valid()) {
                double dist = dq.distance((DBIDRef)id1, (DBIDRef)id2);
                if (!(Double.isNaN(dist) || Double.isInfinite(dist) || this.skipzero && !(dist > 0.0))) {
                    minmax.put(dist);
                }
                id2.advance();
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            id1.advance();
        }
        double zoom = minmax.getMax() - minmax.getMin();
        if (zoom > 0.0) {
            zoom = 1.0 / zoom;
        }
        LinearScaling scale = new LinearScaling(zoom, -minmax.getMin() * zoom);
        BufferedImage img = new BufferedImage(size, size, 1);
        DBIDArrayMIter id12 = order.iter();
        DBIDArrayMIter id22 = order.iter();
        for (int x = 0; x < size && id12.valid(); ++x) {
            id22.seek(id12.getOffset());
            for (int y = x; y < size && id22.valid(); ++y) {
                double ddist = dq.distance((DBIDRef)id12, (DBIDRef)id22);
                if (ddist > 0.0) {
                    ddist = scale.getScaled(ddist);
                }
                if (this.scaling != null) {
                    ddist = this.scaling.getScaled(ddist);
                }
                int dist = 0xFF & (int)(255.0 * ddist);
                int col = 0xFF000000 | dist << 16 | dist << 8 | dist;
                img.setRGB(x, y, col);
                img.setRGB(y, x, col);
                id22.advance();
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            id12.advance();
        }
        LOG.ensureCompleted(prog);
        return new SimilarityMatrix(img, relation, (ArrayDBIDs)order);
    }

    public void processNewResult(Object result) {
        Relation relation;
        Database db = ResultUtil.findDatabase((Object)result);
        boolean nonefound = true;
        List oresults = OutlierResult.getOutlierResults((Object)result);
        List orderings = ResultUtil.getOrderingResults((Object)result);
        for (OutlierResult o : oresults) {
            OrderingResult or = o.getOrdering();
            relation = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
            Metadata.hierarchyOf((Object)or).addChild((Object)this.computeSimilarityMatrixImage(relation, (DBIDIter)or.order(relation.getDBIDs()).iter()));
            orderings.remove(or);
            nonefound = false;
        }
        for (OrderingResult or : orderings) {
            Relation relation2 = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
            DBIDArrayMIter iter = or.order(relation2.getDBIDs()).iter();
            Metadata.hierarchyOf((Object)or).addChild((Object)this.computeSimilarityMatrixImage(relation2, (DBIDIter)iter));
            nonefound = false;
        }
        if (nonefound) {
            ArrayList iter = ResultUtil.filterResults((Object)result, Database.class);
            for (Database database : iter) {
                relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
                Metadata.hierarchyOf((Object)db).addChild((Object)this.computeSimilarityMatrixImage(relation, relation.iterDBIDs()));
            }
        }
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID SCALING_ID = new OptionID("simmatrix.scaling", "Class to use as scaling function.");
        public static final OptionID SKIPZERO_ID = new OptionID("simmatrix.skipzero", "Skip zero values when computing the colors to increase contrast.");
        private Distance<O> distance;
        private ScalingFunction scaling;
        private boolean skipzero = false;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new ObjectParameter(SCALING_ID, ScalingFunction.class).setOptional(true).grab(config, x -> {
                this.scaling = x;
            });
            new Flag(SKIPZERO_ID).grab(config, x -> {
                this.skipzero = x;
            });
        }

        public ComputeSimilarityMatrixImage<O> make() {
            return new ComputeSimilarityMatrixImage<O>(this.distance, this.scaling, this.skipzero);
        }
    }

    public static class SimilarityMatrix
    implements PixmapResult {
        private static final String IMGFILEPREFIX = "elki-pixmap-";
        Relation<?> relation;
        ArrayDBIDs ids;
        RenderedImage img;
        File imgfile = null;

        public SimilarityMatrix(RenderedImage img, Relation<?> relation, ArrayDBIDs ids) {
            this.img = img;
            this.relation = relation;
            this.ids = ids;
        }

        @Override
        public RenderedImage getImage() {
            return this.img;
        }

        @Override
        public File getAsFile() {
            if (this.imgfile == null) {
                try {
                    this.imgfile = Files.createTempFile(IMGFILEPREFIX, ".png", new FileAttribute[0]).toFile();
                    this.imgfile.deleteOnExit();
                    ImageIO.write(this.img, "PNG", this.imgfile);
                }
                catch (IOException e) {
                    LoggingUtil.exception((String)"Could not generate OPTICS plot.", (Throwable)e);
                }
            }
            return this.imgfile;
        }

        public Relation<?> getRelation() {
            return this.relation;
        }

        public ArrayDBIDs getIDs() {
            return this.ids;
        }

        public String getLongName() {
            return "Similarity Matrix";
        }

        public String getShortName() {
            return "sim-matrix";
        }
    }
}

