/*
 * Decompiled with CFR 0.152.
 */
package elki.index.idistance;

import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.type.TypeInformation;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.AbstractRefiningIndex;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.index.RangeIndex;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.MeanVarianceMinMax;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@References(value={@Reference(authors="C. Yu, B. C. Ooi, K. L. Tan, H. V. Jagadish", title="Indexing the distance: An efficient method to knn processing", booktitle="Proc. 27th Int. Conf. on Very Large Data Bases", url="http://www.vldb.org/conf/2001/P421.pdf", bibkey="DBLP:conf/vldb/OoiYTJ01"), @Reference(authors="H. V. Jagadish, B. C. Ooi, K. L. Tan, C. Yu, R. Zhang", title="iDistance: An adaptive B+-tree based indexing method for nearest neighbor search", booktitle="ACM Transactions on Database Systems (TODS), 30(2)", url="https://doi.org/10.1145/1071610.1071612", bibkey="DBLP:journals/tods/JagadishOTYZ05")})
public class InMemoryIDistanceIndex<O>
extends AbstractRefiningIndex<O>
implements RangeIndex<O>,
KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(InMemoryIDistanceIndex.class);
    private DistanceQuery<O> distanceQuery;
    private KMedoidsInitialization<O> initialization;
    private int numref;
    private ArrayDBIDs referencepoints;
    private ModifiableDoubleDBIDList[] index;

    public InMemoryIDistanceIndex(Relation<O> relation, DistanceQuery<O> distance, KMedoidsInitialization<O> initialization, int numref) {
        super(relation);
        this.distanceQuery = distance;
        this.initialization = initialization;
        this.numref = numref;
        if (!distance.getDistance().isMetric()) {
            LOG.warning((CharSequence)("iDistance assumes metric distance functions.\n" + distance.getDistance().getClass() + " does not report itself as metric.\niDistance will run, but may yield approximate results."));
        }
    }

    public void initialize() {
        this.referencepoints = DBIDUtil.ensureArray((DBIDs)this.initialization.chooseInitialMedoids(this.numref, this.relation.getDBIDs(), this.distanceQuery));
        int k = this.referencepoints.size();
        this.index = new ModifiableDoubleDBIDList[k];
        for (int i = 0; i < k; ++i) {
            this.index[i] = DBIDUtil.newDistanceDBIDList((int)(this.relation.size() / (2 * k)));
        }
        DBIDArrayIter riter = this.referencepoints.iter();
        DBIDIter oiter = this.relation.iterDBIDs();
        while (oiter.valid()) {
            double bestd = Double.POSITIVE_INFINITY;
            int besti = -1;
            riter.seek(0);
            while (riter.valid()) {
                double dist = this.distanceQuery.distance((DBIDRef)oiter, (DBIDRef)riter);
                if (dist < bestd) {
                    bestd = dist;
                    besti = riter.getOffset();
                }
                riter.advance();
            }
            assert (besti >= 0 && besti < k);
            this.index[besti].add(bestd, (DBIDRef)oiter);
            oiter.advance();
        }
        for (int i = 0; i < k; ++i) {
            this.index[i].sort();
        }
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return distanceQuery.getRelation() == this.relation && this.getDistance().equals((Object)distanceQuery.getDistance()) ? new IDistanceKNNSearcher(distanceQuery) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && this.getDistance().equals((Object)distanceQuery.getDistance()) ? new IDistanceRangeSearcher(distanceQuery) : null;
    }

    private Distance<? super O> getDistance() {
        return this.distanceQuery.getDistance();
    }

    public Logging getLogger() {
        return LOG;
    }

    public void logStatistics() {
        super.logStatistics();
        MeanVarianceMinMax mm = new MeanVarianceMinMax();
        for (int i = 0; i < this.index.length; ++i) {
            mm.put((double)this.index[i].size());
        }
        LOG.statistics((Statistic)new LongStatistic(InMemoryIDistanceIndex.class.getName() + ".size.min", (long)((int)mm.getMin())));
        LOG.statistics((Statistic)new DoubleStatistic(InMemoryIDistanceIndex.class.getName() + ".size.mean", mm.getMean()));
        LOG.statistics((Statistic)new LongStatistic(InMemoryIDistanceIndex.class.getName() + ".size.max", (long)((int)mm.getMax())));
    }

    protected static <O> DoubleIntPair[] rankReferencePoints(DistanceQuery<O> distanceQuery, O obj, ArrayDBIDs referencepoints) {
        Object[] priority = new DoubleIntPair[referencepoints.size()];
        DBIDArrayIter iter = referencepoints.iter();
        while (iter.valid()) {
            int i = iter.getOffset();
            double dist = distanceQuery.distance(obj, (DBIDRef)iter);
            priority[i] = new DoubleIntPair(dist, i);
            iter.advance();
        }
        Arrays.sort(priority);
        return priority;
    }

    protected static void binarySearch(ModifiableDoubleDBIDList index, DoubleDBIDListIter iter, double val) {
        int left = 0;
        int right = index.size();
        while (left < right) {
            int mid = left + right >>> 1;
            double curd = iter.seek(mid).doubleValue();
            if (val < curd) {
                right = mid;
                continue;
            }
            if (val > curd) {
                left = mid + 1;
                continue;
            }
            left = mid;
            break;
        }
        if (left >= index.size()) {
            --left;
        }
        iter.seek(left);
    }

    public static class Factory<V>
    implements IndexFactory<V> {
        Distance<? super V> distance;
        KMedoidsInitialization<V> initialization;
        int k;

        public Factory(Distance<? super V> distance, KMedoidsInitialization<V> initialization, int k) {
            this.distance = distance;
            this.initialization = initialization;
            this.k = k;
        }

        public InMemoryIDistanceIndex<V> instantiate(Relation<V> relation) {
            return new InMemoryIDistanceIndex<V>(relation, this.distance.instantiate(relation), this.initialization, this.k);
        }

        public TypeInformation getInputTypeRestriction() {
            return this.distance.getInputTypeRestriction();
        }

        public static class Par<V>
        implements Parameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("idistance.distance", "Distance function to build the index for.");
            public static final OptionID REFERENCE_ID = new OptionID("idistance.reference", "Method to choose the reference points.");
            public static final OptionID K_ID = new OptionID("idistance.k", "Number of reference points to use.");
            Distance<? super V> distance;
            KMedoidsInitialization<V> initialization;
            int k;

            public void configure(Parameterization config) {
                new ObjectParameter(DISTANCE_ID, Distance.class).grab(config, x -> {
                    this.distance = x;
                });
                new ObjectParameter(REFERENCE_ID, KMedoidsInitialization.class).grab(config, x -> {
                    this.initialization = x;
                });
                ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.k = x;
                });
            }

            public Factory<V> make() {
                return new Factory<V>(this.distance, this.initialization, this.k);
            }
        }
    }

    protected class IDistanceRangeSearcher
    extends AbstractRefiningIndex.AbstractRefiningQuery
    implements RangeSearcher<O> {
        public IDistanceRangeSearcher(DistanceQuery<O> distanceQuery) {
            super((AbstractRefiningIndex)InMemoryIDistanceIndex.this, distanceQuery);
        }

        public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
            DoubleIntPair[] priority;
            for (DoubleIntPair pair : priority = InMemoryIDistanceIndex.rankReferencePoints(this.distanceQuery, obj, InMemoryIDistanceIndex.this.referencepoints)) {
                double lbbwd;
                ModifiableDoubleDBIDList nindex = InMemoryIDistanceIndex.this.index[pair.second];
                double refd = pair.first;
                DoubleDBIDListMIter ifwd = nindex.iter();
                DoubleDBIDListMIter ibwd = nindex.iter();
                InMemoryIDistanceIndex.binarySearch(nindex, (DoubleDBIDListIter)ibwd, refd);
                ifwd.seek(ibwd.getOffset() + 1);
                double lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                double d = lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                while (lbfwd <= range || lbbwd <= range) {
                    double dist;
                    if (lbfwd <= range && !(lbfwd > lbbwd)) {
                        dist = this.refine((DBIDRef)ifwd, obj);
                        if (dist <= range) {
                            result.add(dist, (DBIDRef)ifwd);
                        }
                        ifwd.advance();
                        double d2 = lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                    }
                    if (!(lbbwd <= range) || lbbwd > lbfwd) continue;
                    dist = this.refine((DBIDRef)ibwd, obj);
                    if (dist <= range) {
                        result.add(dist, (DBIDRef)ibwd);
                    }
                    ibwd.retract();
                    lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                }
            }
            return result;
        }
    }

    protected class IDistanceKNNSearcher
    extends AbstractRefiningIndex.AbstractRefiningQuery
    implements KNNSearcher<O> {
        public IDistanceKNNSearcher(DistanceQuery<O> distanceQuery) {
            super((AbstractRefiningIndex)InMemoryIDistanceIndex.this, distanceQuery);
        }

        public KNNList getKNN(O obj, int k) {
            DoubleIntPair[] priority = InMemoryIDistanceIndex.rankReferencePoints(this.distanceQuery, obj, InMemoryIDistanceIndex.this.referencepoints);
            KNNHeap heap = DBIDUtil.newHeap((int)k);
            for (DoubleIntPair pair : priority) {
                ModifiableDoubleDBIDList nindex = InMemoryIDistanceIndex.this.index[pair.second];
                double refd = pair.first;
                DoubleDBIDListMIter ifwd = nindex.iter();
                DoubleDBIDListMIter ibwd = nindex.iter();
                InMemoryIDistanceIndex.binarySearch(nindex, (DoubleDBIDListIter)ibwd, refd);
                ifwd.seek(ibwd.getOffset() + 1);
                double lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                double lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                double kdist = heap.getKNNDistance();
                while (lbfwd <= kdist || lbbwd <= kdist) {
                    double dist;
                    if (lbfwd <= kdist && !(lbfwd > lbbwd)) {
                        dist = this.refine((DBIDRef)ifwd, obj);
                        if (dist <= kdist) {
                            heap.insert(dist, (DBIDRef)ifwd);
                            kdist = heap.getKNNDistance();
                        }
                        ifwd.advance();
                        double d = lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                    }
                    if (!(lbbwd <= kdist) || lbbwd > lbfwd) continue;
                    dist = this.refine((DBIDRef)ibwd, obj);
                    if (dist <= kdist) {
                        heap.insert(dist, (DBIDRef)ibwd);
                        kdist = heap.getKNNDistance();
                    }
                    ibwd.retract();
                    lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                }
            }
            return heap.toKNNList();
        }
    }
}

