/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.algorithm.KNNJoin;
import elki.data.spatial.SpatialComparable;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.SpatialPrimitiveDistance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.logging.Logging;

public class KNNJoinMaterializeKNNPreprocessor<V extends SpatialComparable>
extends AbstractMaterializeKNNPreprocessor<V> {
    private static final Logging LOG = Logging.getLogger(KNNJoinMaterializeKNNPreprocessor.class);

    public KNNJoinMaterializeKNNPreprocessor(Relation<V> relation, Distance<? super V> distance, int k) {
        super(relation, distance, k);
    }

    protected void preprocess() {
        SpatialPrimitiveDistance distFunction = (SpatialPrimitiveDistance)this.distance;
        this.storage = new KNNJoin(distFunction, this.k).run((Relation<? extends SpatialComparable>)this.relation, this.relation.getDBIDs());
    }

    protected Logging getLogger() {
        return LOG;
    }

    public String getLongName() {
        return "knn-join materialized neighbors";
    }

    public String getShortName() {
        return "knn-join";
    }

    public static class Factory<O extends SpatialComparable>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        public Factory(int k, Distance<? super O> distance) {
            super(k, distance);
        }

        public KNNJoinMaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            return new KNNJoinMaterializeKNNPreprocessor<O>(relation, this.distance, this.k);
        }

        public static class Par<O extends SpatialComparable>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<O> {
            public Factory<O> make() {
                return new Factory(this.k, this.distance);
            }
        }
    }
}

