/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier;

import elki.Algorithm;
import elki.clustering.optics.AbstractOPTICS;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="OPTICS-OF: Identifying Local Outliers")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'minpts'")
@Reference(authors="Markus M. Breunig, Hans-Peter Kriegel, Raymond Ng, J\u00f6rg Sander", title="OPTICS-OF: Identifying Local Outliers", booktitle="Proc. 3rd European Conf. on Principles of Knowledge Discovery and Data Mining (PKDD'99)", url="https://doi.org/10.1007/978-3-540-48247-5_28", bibkey="DBLP:conf/pkdd/BreunigKNS99")
public class OPTICSOF<O>
implements OutlierAlgorithm {
    protected Distance<? super O> distance;
    protected int minpts;

    public OPTICSOF(Distance<? super O> distance, int minpts) {
        this.distance = distance;
        this.minpts = minpts;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.minpts);
        DBIDs ids = relation.getDBIDs();
        WritableDataStore nMinPts = DataStoreUtil.makeStorage((DBIDs)ids, (int)3, KNNList.class);
        WritableDoubleDataStore coreDistance = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList minptsNeighbours = knnQuery.getKNN((Object)iditer, this.minpts);
            double d = minptsNeighbours.getKNNDistance();
            nMinPts.put((DBIDRef)iditer, (Object)minptsNeighbours);
            coreDistance.putDouble((DBIDRef)iditer, d);
            iditer.advance();
        }
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            KNNList neighbors = (KNNList)nMinPts.get((DBIDRef)iditer2);
            double lrd = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                double coreDist = coreDistance.doubleValue((DBIDRef)neighbor);
                double rd = MathUtil.max((double)coreDist, (double)neighbor.doubleValue());
                lrd += rd;
                neighbor.advance();
            }
            lrd = (double)neighbors.size() / lrd;
            lrds.putDouble((DBIDRef)iditer2, lrd);
            iditer2.advance();
        }
        DoubleMinMax ofminmax = new DoubleMinMax();
        WritableDoubleDataStore ofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            KNNList neighbors = (KNNList)nMinPts.get((DBIDRef)iditer3);
            double lrd = lrds.doubleValue((DBIDRef)iditer3);
            double of = 0.0;
            if (lrd > 0.0) {
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    of += lrds.doubleValue((DBIDRef)neighbor) / lrd;
                    neighbor.advance();
                }
                of /= (double)neighbors.size();
            }
            ofs.putDouble((DBIDRef)iditer3, of);
            ofminmax.put(of);
            iditer3.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("OPTICS Outlier Scores", relation.getDBIDs(), (DoubleDataStore)ofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(ofminmax.getMin(), ofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult((OutlierScoreMeta)scoreMeta, (DoubleRelation)scoreResult);
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;
        protected int minpts = 0;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(AbstractOPTICS.Par.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.minpts = x;
            });
        }

        public OPTICSOF<O> make() {
            return new OPTICSOF<O>(this.distance, this.minpts);
        }
    }
}

