/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier;

import elki.Algorithm;
import elki.algorithm.DependencyDerivator;
import elki.data.NumberVector;
import elki.data.model.CorrelationAnalysisSolution;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.math.linearalgebra.VMath;
import elki.math.linearalgebra.pca.PCARunner;
import elki.math.linearalgebra.pca.filter.EigenPairFilter;
import elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import elki.math.statistics.distribution.NormalDistribution;
import elki.outlier.OutlierAlgorithm;
import elki.result.Metadata;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Simple COP: Correlation Outlier Probability")
@Reference(authors="Arthur Zimek", title="Application 2: Outlier Detection (Chapter 18)", booktitle="Correlation Clustering", bibkey="phd/dnb/Zimek08/Ch18")
public class SimpleCOP<V extends NumberVector>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleCOP.class);
    protected Distance<? super V> distance;
    protected int kplus;
    protected DependencyDerivator<V> dependencyDerivator;

    public SimpleCOP(Distance<? super V> distance, int k, PCARunner pca, EigenPairFilter filter) {
        this.distance = distance;
        this.kplus = k + 1;
        this.dependencyDerivator = new DependencyDerivator(null, FormatUtil.NF, pca, filter, 0, false);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Relation<V> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.kplus);
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore cop_score = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)6);
        WritableDataStore cop_err_v = DataStoreUtil.makeStorage((DBIDs)ids, (int)6, double[].class);
        WritableDataStore cop_datav = DataStoreUtil.makeStorage((DBIDs)ids, (int)6, double[].class);
        WritableIntegerDataStore cop_dim = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)6, (int)-1);
        WritableDataStore cop_sol = DataStoreUtil.makeStorage((DBIDs)ids, (int)6, CorrelationAnalysisSolution.class);
        FiniteProgress progressLocalPCA = LOG.isVerbose() ? new FiniteProgress("Correlation Outlier Probabilities", relation.size(), LOG) : null;
        double sqrt2 = MathUtil.SQRT2;
        DBIDIter id = relation.iterDBIDs();
        while (id.valid()) {
            KNNList neighbors = knnQuery.getKNN((Object)id, this.kplus);
            ArrayModifiableDBIDs nids = DBIDUtil.newArray((DBIDs)neighbors);
            nids.remove((DBIDRef)id);
            CorrelationAnalysisSolution depsol = this.dependencyDerivator.generateModel(relation, (DBIDs)nids);
            double stddev = depsol.getStandardDeviation();
            double distance = Math.sqrt(depsol.squaredDistance((NumberVector)relation.get((DBIDRef)id)));
            double prob = NormalDistribution.erf((double)(distance / (stddev * sqrt2)));
            cop_score.putDouble((DBIDRef)id, prob);
            cop_err_v.put((DBIDRef)id, (Object)VMath.times((double[])depsol.errorVector((NumberVector)relation.get((DBIDRef)id)), (double)-1.0));
            cop_datav.put((DBIDRef)id, (Object)depsol.dataVector((NumberVector)relation.get((DBIDRef)id)));
            cop_dim.putInt((DBIDRef)id, depsol.getCorrelationDimensionality());
            cop_sol.put((DBIDRef)id, (Object)depsol);
            LOG.incrementProcessed((AbstractProgress)progressLocalPCA);
            id.advance();
        }
        LOG.ensureCompleted(progressLocalPCA);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Original Correlation Outlier Probabilities", ids, (DoubleDataStore)cop_score);
        ProbabilisticOutlierScore scoreMeta = new ProbabilisticOutlierScore();
        OutlierResult result = new OutlierResult((OutlierScoreMeta)scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)result).addChild((Object)new MaterializedRelation("Local Correlation Dimensionality", TypeUtil.INTEGER, ids, (DataStore)cop_dim));
        Metadata.hierarchyOf((Object)result).addChild((Object)new MaterializedRelation("Error vectors", TypeUtil.DOUBLE_ARRAY, ids, (DataStore)cop_err_v));
        Metadata.hierarchyOf((Object)result).addChild((Object)new MaterializedRelation("Data vectors", TypeUtil.DOUBLE_ARRAY, ids, (DataStore)cop_datav));
        Metadata.hierarchyOf((Object)result).addChild((Object)new MaterializedRelation("Correlation analysis", new SimpleTypeInformation(CorrelationAnalysisSolution.class), ids, (DataStore)cop_sol));
        return result;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("cop.k", "The number of nearest neighbors of an object to be considered for computing its COP_SCORE.");
        public static final OptionID PCARUNNER_ID = new OptionID("cop.pcarunner", "The class to compute (filtered) PCA.");
        protected Distance<? super V> distance;
        protected int k;
        protected PCARunner pca;
        protected EigenPairFilter filter;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(PCARUNNER_ID, PCARunner.class, PCARunner.class).grab(config, x -> {
                this.pca = x;
            });
            new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, EigenPairFilter.class, PercentageEigenPairFilter.class).grab(config, x -> {
                this.filter = x;
            });
        }

        public SimpleCOP<V> make() {
            return new SimpleCOP<V>(this.distance, this.k, this.pca, this.filter);
        }
    }
}

