/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.clustering;

import elki.clustering.dbscan.GeneralizedDBSCAN;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.CoreObjectsModel;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.outlier.OutlierAlgorithm;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.List;

@Title(value="DBSCAN Outlier Detection: Outlier Detection based on the Generalized DBSCAN clustering")
public class DBSCANOutlierDetection
implements OutlierAlgorithm {
    private GeneralizedDBSCAN clusterer;

    public DBSCANOutlierDetection(GeneralizedDBSCAN clusterer) {
        this.clusterer = clusterer;
    }

    public OutlierResult run(Database db, Relation<? extends NumberVector> relation) {
        Clustering c = this.clusterer.autorun(db);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30);
        double noise = 1.0;
        double border = 0.5;
        double core = 0.0;
        List topLevelClusters = c.getToplevelClusters();
        for (Object obj : topLevelClusters) {
            DBIDIter iter;
            Cluster cluster = (Cluster)obj;
            if (cluster.isNoise()) {
                iter = cluster.getIDs().iter();
                while (iter.valid()) {
                    scores.put((DBIDRef)iter, 1.0);
                    iter.advance();
                }
                continue;
            }
            if (cluster.getModel() instanceof CoreObjectsModel) {
                DBIDs coreObjects = ((CoreObjectsModel)cluster.getModel()).getCoreObjects();
                DBIDIter iter2 = cluster.getIDs().iter();
                while (iter2.valid()) {
                    scores.put((DBIDRef)iter2, 0.5);
                    iter2.advance();
                }
                iter2 = coreObjects.iter();
                while (iter2.valid()) {
                    scores.put((DBIDRef)iter2, 0.0);
                    iter2.advance();
                }
                continue;
            }
            iter = cluster.getIDs().iter();
            while (iter.valid()) {
                scores.put((DBIDRef)iter, 0.0);
                iter.advance();
            }
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("DBSCAN outlier score", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(0.0, 1.0, 0.0, 1.0, 0.0);
        OutlierResult result = new OutlierResult((OutlierScoreMeta)scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)result).addChild((Object)c);
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.clusterer.getInputTypeRestriction();
    }

    public static class Par
    implements Parameterizer {
        protected GeneralizedDBSCAN clusterer;

        public void configure(Parameterization config) {
            this.clusterer = (GeneralizedDBSCAN)config.tryInstantiate(GeneralizedDBSCAN.class);
        }

        public DBSCANOutlierDetection make() {
            return new DBSCANOutlierDetection(this.clusterer);
        }
    }
}

