/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.clustering;

import elki.clustering.hierarchical.extraction.HDBSCANHierarchyExtraction;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Title(value="GLOSH: Global-Local Outlier Scores from Hierarchies")
@Description(value="The GLOSH outlier score assigned is based on a sound statistical interpretation from the HDBSCAN hierarchy.")
@Reference(authors="R. J. G. B. Campello, D. Moulavi, A. Zimek, J. Sander", title="Hierarchical Density Estimates for Data Clustering, Visualization, and Outlier Detection", booktitle="ACM Trans. Knowl. Discov. Data 10(1)", url="https://doi.org/10.1145/2733381", bibkey="DBLP:journals/tkdd/CampelloMZS15")
public class GLOSH
implements OutlierAlgorithm {
    private HDBSCANHierarchyExtraction hdbscanExtraction;

    public GLOSH(HDBSCANHierarchyExtraction hdbscanExtraction) {
        this.hdbscanExtraction = hdbscanExtraction;
    }

    public OutlierResult run(Database db, Relation<? extends NumberVector> relation) {
        Clustering hdbscanresult = this.hdbscanExtraction.autorun(db);
        WritableDoubleDataStore scores = null;
        It iter = Metadata.hierarchyOf((Object)hdbscanresult).iterChildren().filter(WritableDoubleDataStore.class);
        while (iter.valid()) {
            scores = (WritableDoubleDataStore)iter.get();
            iter.advance();
        }
        if (scores == null) {
            throw new IllegalStateException("Were not GLOSH scores generated from clustering hierarchies?");
        }
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            minmax.put(scores.doubleValue((DBIDRef)iditer));
            iditer.advance();
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, 1.0);
        OutlierResult result = new OutlierResult((OutlierScoreMeta)meta, (DoubleRelation)new MaterializedDoubleRelation("GLOSH score", relation.getDBIDs(), (DoubleDataStore)scores));
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par
    implements Parameterizer {
        protected HDBSCANHierarchyExtraction hdbscanExtraction;

        public void configure(Parameterization config) {
            this.hdbscanExtraction = (HDBSCANHierarchyExtraction)config.tryInstantiate(HDBSCANHierarchyExtraction.class);
        }

        public GLOSH make() {
            return new GLOSH(this.hdbscanExtraction);
        }
    }
}

