/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.clustering;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.kmeans.KMeansMinusMinus;
import elki.database.Database;
import elki.outlier.clustering.NoiseAsOutliers;
import elki.result.Metadata;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.ChainedParameterization;
import elki.utilities.optionhandling.parameterization.ListParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Title(value="K-Means--")
@Reference(authors="S. Chawla, A. Gionis", title="k-means--: A Unified Approach to Clustering and Outlier Detection", booktitle="Proc. 13th SIAM Int. Conf. on Data Mining (SDM 2013)", url="https://doi.org/10.1137/1.9781611972832.21", bibkey="DBLP:conf/sdm/ChawlaG13")
public class KMeansMinusMinusOutlierDetection
extends NoiseAsOutliers {
    public KMeansMinusMinusOutlierDetection(KMeansMinusMinus<?> kmeansminusminus) {
        super((ClusteringAlgorithm<?>)kmeansminusminus);
    }

    @Override
    public OutlierResult autorun(Database database) {
        OutlierResult res = super.autorun(database);
        Metadata.of((Object)res).setLongName("K-means-- outlier labels");
        return res;
    }

    public static class Par
    implements Parameterizer {
        KMeansMinusMinus<?> kmeansminusminus;

        public void configure(Parameterization config) {
            ChainedParameterization list = new ChainedParameterization(new Parameterization[]{new ListParameterization().addFlag(KMeansMinusMinus.Par.NOISE_FLAG_ID), config});
            list.errorsTo(config);
            this.kmeansminusminus = (KMeansMinusMinus)list.tryInstantiate(KMeansMinusMinus.class);
        }

        public KMeansMinusMinusOutlierDetection make() {
            return new KMeansMinusMinusOutlierDetection(this.kmeansminusminus);
        }
    }
}

