/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.clustering;

import elki.clustering.kmeans.ExponionKMeans;
import elki.clustering.kmeans.KMeans;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.model.ModelUtil;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SparseSquaredEuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class KMeansOutlierDetection<O extends NumberVector>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KMeansOutlierDetection.class);
    KMeans<O, ?> clusterer;
    Rule rule;

    public KMeansOutlierDetection(KMeans<O, ?> clusterer, Rule rule) {
        this.clusterer = clusterer;
        this.rule = rule;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.clusterer.getDistance().getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        Clustering c = this.clusterer.run(relation);
        NumberVectorDistance distfunc = this.clusterer.getDistance();
        if (this.rule == Rule.VARIANCE && !(distfunc instanceof SquaredEuclideanDistance) && !(distfunc instanceof SparseSquaredEuclideanDistance)) {
            LOG.warning((CharSequence)"K-means should be used with squared Euclidean distance only.");
        }
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30);
        DoubleMinMax mm = new DoubleMinMax();
        switch (this.rule) {
            case DISTANCE: {
                this.distanceScoring(c, relation, distfunc, scores, mm);
                break;
            }
            case DISTANCE_SINGLETONS: {
                this.singletonsScoring(c, relation, distfunc, scores, mm);
                break;
            }
            case VARIANCE: {
                this.varianceScoring(c, relation, distfunc, scores, mm);
            }
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("KMeans outlier scores", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult((OutlierScoreMeta)scoreMeta, (DoubleRelation)scoreResult);
    }

    private void distanceScoring(Clustering<?> c, Relation<O> relation, NumberVectorDistance<? super O> distfunc, WritableDoubleDataStore scores, DoubleMinMax mm) {
        List clusters = c.getAllClusters();
        for (Cluster cluster : clusters) {
            NumberVector mean = ModelUtil.getPrototype((Model)cluster.getModel(), relation);
            DBIDIter iter = cluster.getIDs().iter();
            while (iter.valid()) {
                NumberVector obj = (NumberVector)relation.get((DBIDRef)iter);
                double score = Double.NaN;
                score = cluster.size() == 1 ? 0.0 : distfunc.distance(mean, obj);
                scores.put((DBIDRef)iter, score);
                mm.put(score);
                iter.advance();
            }
        }
    }

    private void singletonsScoring(Clustering<?> c, Relation<O> relation, NumberVectorDistance<? super O> distfunc, WritableDoubleDataStore scores, DoubleMinMax mm) {
        List clusters = c.getAllClusters();
        for (Cluster cluster : clusters) {
            NumberVector mean = ModelUtil.getPrototype((Model)cluster.getModel(), relation);
            DBIDIter iter = cluster.getIDs().iter();
            while (iter.valid()) {
                NumberVector obj = (NumberVector)relation.get((DBIDRef)iter);
                double score = Double.NaN;
                if (cluster.size() == 1 && clusters.size() > 1) {
                    score = Double.POSITIVE_INFINITY;
                    for (Cluster c2 : clusters) {
                        double dist = distfunc.distance(ModelUtil.getPrototype((Model)c2.getModel(), relation), obj);
                        score = dist < score ? dist : score;
                    }
                } else {
                    score = distfunc.distance(mean, obj);
                }
                scores.put((DBIDRef)iter, score);
                mm.put(score);
                iter.advance();
            }
        }
    }

    private void varianceScoring(Clustering<?> c, Relation<O> relation, NumberVectorDistance<? super O> distfunc, WritableDoubleDataStore scores, DoubleMinMax mm) {
        List clusters = c.getAllClusters();
        for (Cluster cluster : clusters) {
            NumberVector mean = ModelUtil.getPrototype((Model)cluster.getModel(), relation);
            DBIDIter iter = cluster.getIDs().iter();
            while (iter.valid()) {
                NumberVector obj = (NumberVector)relation.get((DBIDRef)iter);
                double score = Double.NaN;
                if (cluster.size() == 1 && clusters.size() > 1) {
                    score = Double.POSITIVE_INFINITY;
                    for (Cluster c2 : clusters) {
                        double dist = distfunc.distance(ModelUtil.getPrototype((Model)c2.getModel(), relation), obj);
                        score = (dist = dist * (double)c2.size() / (double)(c2.size() + 1)) < score ? dist : score;
                    }
                } else {
                    score = distfunc.distance(mean, obj) * (double)cluster.size() / (double)(cluster.size() - 1);
                }
                scores.put((DBIDRef)iter, score);
                mm.put(score);
                iter.advance();
            }
        }
    }

    public static class Par<O extends NumberVector>
    implements Parameterizer {
        public static final OptionID CLUSTERING_ID = new OptionID("kmeans.algorithm", "Clustering algorithm to use for detecting outliers.");
        public static final OptionID RULE_ID = new OptionID("kmeansod.scoring", "Scoring rule for scoring outliers.");
        KMeans<O, ?> clusterer;
        Rule rule;

        public void configure(Parameterization config) {
            new ObjectParameter(CLUSTERING_ID, KMeans.class, ExponionKMeans.class).grab(config, x -> {
                this.clusterer = x;
            });
            new EnumParameter(RULE_ID, Rule.class, (Enum)Rule.VARIANCE).grab(config, x -> {
                this.rule = x;
            });
        }

        public KMeansOutlierDetection<O> make() {
            return new KMeansOutlierDetection<O>(this.clusterer, this.rule);
        }
    }

    public static enum Rule {
        DISTANCE,
        DISTANCE_SINGLETONS,
        VARIANCE;

    }
}

