/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.clustering;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class NoiseAsOutliers
implements OutlierAlgorithm {
    ClusteringAlgorithm<?> clustering;

    public NoiseAsOutliers(ClusteringAlgorithm<?> clustering) {
        this.clustering = clustering;
    }

    public OutlierResult autorun(Database database) {
        Clustering c = this.clustering.autorun(database);
        DBIDs ids = database.getRelation((TypeInformation)TypeUtil.DBID, new Object[0]).getDBIDs();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        DoubleMinMax mm = new DoubleMinMax();
        List clusters = c.getAllClusters();
        for (Cluster cluster : clusters) {
            DBIDIter iter;
            if (cluster.isNoise()) {
                iter = cluster.getIDs().iter();
                while (iter.valid()) {
                    scores.put((DBIDRef)iter, 1.0);
                    iter.advance();
                }
                mm.put(1.0);
                continue;
            }
            iter = cluster.getIDs().iter();
            while (iter.valid()) {
                scores.put((DBIDRef)iter, 0.0);
                iter.advance();
            }
            mm.put(0.0);
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Noise as outliers", ids, (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, 1.0, 0.0);
        return new OutlierResult((OutlierScoreMeta)scoreMeta, (DoubleRelation)scoreResult);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.clustering.getInputTypeRestriction();
    }

    public static class Par
    implements Parameterizer {
        ClusteringAlgorithm<?> clustering;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.ALGORITHM_ID, ClusteringAlgorithm.class).grab(config, x -> {
                this.clustering = x;
            });
        }

        public NoiseAsOutliers make() {
            return new NoiseAsOutliers(this.clustering);
        }
    }
}

