/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.clustering;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.data.Clustering;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.evaluation.clustering.internal.Silhouette;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.Metadata;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="P. J. Rousseeuw", title="Silhouettes: A graphical aid to the interpretation and validation of cluster analysis", booktitle="Journal of Computational and Applied Mathematics, Volume 20", url="https://doi.org/10.1016/0377-0427(87)90125-7", bibkey="doi:10.1016/0377-04278790125-7")
public class SilhouetteOutlierDetection<O>
implements OutlierAlgorithm {
    protected Distance<? super O> distance;
    protected ClusteringAlgorithm<?> clusterer;
    protected NoiseHandling noiseOption = NoiseHandling.TREAT_NOISE_AS_SINGLETONS;

    public SilhouetteOutlierDetection(Distance<? super O> distance, ClusteringAlgorithm<?> clusterer, NoiseHandling noiseOption) {
        this.distance = distance;
        this.clusterer = clusterer;
        this.noiseOption = noiseOption;
    }

    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation[] t;
        TypeInformation dt = this.distance.getInputTypeRestriction();
        for (TypeInformation i : t = this.clusterer.getInputTypeRestriction()) {
            if (!dt.isAssignableFromType(i)) continue;
            return t;
        }
        TypeInformation[] t2 = new TypeInformation[t.length + 1];
        t2[0] = dt;
        System.arraycopy(t, 0, t2, 1, t.length);
        return t2;
    }

    public OutlierResult autorun(Database database) {
        Clustering c = this.clusterer.autorun(database);
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        It it = Metadata.hierarchyOf((Object)c).iterDescendants().filter(DoubleRelation.class).filter(x -> "Silhouette scores".equals(x.getLongName()));
        if (!it.valid()) {
            DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
            new Silhouette(this.distance, this.noiseOption, false).evaluateClustering(relation, dq, c);
            it = Metadata.hierarchyOf((Object)c).iterDescendants().filter(DoubleRelation.class).filter(x -> "Silhouette scores".equals(x.getLongName()));
        }
        if (!it.valid()) {
            throw new NullPointerException("Silhouette did not produce Silhouette scores.");
        }
        DoubleRelation scoreResult = (DoubleRelation)it.get();
        DoubleMinMax mm = new DoubleMinMax();
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            mm.put(scoreResult.doubleValue((DBIDRef)iter));
            iter.advance();
        }
        return new OutlierResult((OutlierScoreMeta)new InvertedOutlierScoreMeta(mm.getMin(), mm.getMax(), -1.0, 1.0, 0.5), scoreResult);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID CLUSTERING_ID = new OptionID("silhouette.clustering", "Clustering algorithm to use for the silhouette coefficients.");
        protected Distance<? super O> distance;
        protected ClusteringAlgorithm<?> clusterer;
        protected NoiseHandling noiseOption = NoiseHandling.TREAT_NOISE_AS_SINGLETONS;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new ObjectParameter(CLUSTERING_ID, ClusteringAlgorithm.class).grab(config, x -> {
                this.clusterer = x;
            });
            new EnumParameter(Silhouette.Par.NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
        }

        public SilhouetteOutlierDetection<O> make() {
            return new SilhouetteOutlierDetection<O>(this.distance, this.clusterer, this.noiseOption);
        }
    }
}

