/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.subspace;

import elki.clustering.subspace.SubspaceClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.SubspaceModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.Metadata;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="OutRank: ranking outliers in high dimensional data")
@Description(value="Ranking outliers in high dimensional data - score 1")
@Reference(authors="E. M\u00fcller, I. Assent, U. Steinhausen, T. Seidl", title="OutRank: ranking outliers in high dimensional data", booktitle="Proc. 24th Int. Conf. on Data Engineering (ICDE) Workshop on Ranking in Databases (DBRank)", url="https://doi.org/10.1109/ICDEW.2008.4498387", bibkey="DBLP:conf/icde/MullerASS08")
public class OutRankS1
implements OutlierAlgorithm {
    protected SubspaceClusteringAlgorithm<? extends SubspaceModel> clusteralg;
    double alpha;

    public OutRankS1(SubspaceClusteringAlgorithm<? extends SubspaceModel> clusteralg, double alpha) {
        this.clusteralg = clusteralg;
        this.alpha = alpha;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.clusteralg.getInputTypeRestriction();
    }

    public OutlierResult autorun(Database database) {
        DBIDs ids = database.getRelation((TypeInformation)TypeUtil.ANY, new Object[0]).getDBIDs();
        Clustering clustering = this.clusteralg.autorun(database);
        WritableDoubleDataStore score = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)2);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            score.putDouble((DBIDRef)iter, 0.0);
            iter.advance();
        }
        int maxdim = 0;
        int maxsize = 0;
        for (Object cluster : clustering.getAllClusters()) {
            maxsize = Math.max(maxsize, cluster.size());
            maxdim = Math.max(maxdim, BitsUtil.cardinality((long[])((SubspaceModel)cluster.getModel()).getDimensions()));
        }
        DoubleMinMax minmax = new DoubleMinMax();
        for (Cluster cluster : clustering.getAllClusters()) {
            double relsize = (double)cluster.size() / (double)maxsize;
            double reldim = (double)BitsUtil.cardinality((long[])((SubspaceModel)cluster.getModel()).getDimensions()) / (double)maxdim;
            DBIDIter iter2 = cluster.getIDs().iter();
            while (iter2.valid()) {
                double newscore = score.doubleValue((DBIDRef)iter2) + this.alpha * relsize + (1.0 - this.alpha) * reldim;
                score.putDouble((DBIDRef)iter2, newscore);
                minmax.put(newscore);
                iter2.advance();
            }
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("OutRank-S1", ids, (DoubleDataStore)score);
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult res = new OutlierResult((OutlierScoreMeta)meta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)res).addChild((Object)clustering);
        return res;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID ALGORITHM_ID = new OptionID("outrank.algorithm", "Subspace clustering algorithm to use.");
        public static final OptionID ALPHA_ID = new OptionID("outrank.s1.alpha", "Alpha parameter for S1 score.");
        protected SubspaceClusteringAlgorithm<? extends SubspaceModel> algorithm = null;
        protected double alpha = 0.25;

        public void configure(Parameterization config) {
            new ObjectParameter(ALGORITHM_ID, SubspaceClusteringAlgorithm.class).grab(config, x -> {
                this.algorithm = x;
            });
            ((DoubleParameter)new DoubleParameter(ALPHA_ID, 0.25).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.alpha = x;
            });
        }

        public OutRankS1 make() {
            return new OutRankS1(this.algorithm, this.alpha);
        }
    }
}

