/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.persistent.LRUCache;
import elki.persistent.Page;
import elki.persistent.PageFile;
import elki.persistent.PageFileFactory;
import elki.persistent.PersistentPageFileFactory;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class LRUCachePageFileFactory<P extends Page>
implements PageFileFactory<P> {
    private PageFileFactory<P> pageFileFactory;
    private int cacheSize;

    public LRUCachePageFileFactory(PageFileFactory<P> pageFileFactory, int cacheSize) {
        this.cacheSize = cacheSize;
        this.pageFileFactory = pageFileFactory;
    }

    public PageFile<P> newPageFile(Class<P> cls) {
        PageFile inner = this.pageFileFactory.newPageFile(cls);
        return new LRUCache(this.cacheSize, inner);
    }

    public int getPageSize() {
        return this.pageFileFactory.getPageSize();
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID CACHE_SIZE_ID = new OptionID("pagefile.cachesize", "The size of the cache in bytes.");
        public static final OptionID PAGEFILE_ID = new OptionID("pagefile.pagefile", "The backing pagefile for the cache.");
        PageFileFactory<Page> pageFileFactory;
        protected int cacheSize;

        public void configure(Parameterization config) {
            new ObjectParameter(PAGEFILE_ID, PageFileFactory.class, PersistentPageFileFactory.class).grab(config, x -> {
                this.pageFileFactory = x;
            });
            ((IntParameter)new IntParameter(CACHE_SIZE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT)).grab(config, x -> {
                this.cacheSize = x;
            });
        }

        public LRUCachePageFileFactory<Page> make() {
            return new LRUCachePageFileFactory<Page>(this.pageFileFactory, this.cacheSize);
        }
    }
}

