/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.logging.Logging;
import elki.logging.LoggingUtil;
import elki.persistent.AbstractStoringPageFile;
import elki.persistent.OnDiskArray;
import elki.persistent.Page;
import elki.persistent.PageHeader;
import elki.utilities.io.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;

public class OnDiskArrayPageFile<P extends Page>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(OnDiskArrayPageFile.class);
    private static final int EMPTY_PAGE = 0;
    private static final int FILLED_PAGE = 1;
    private Path filename;
    private OnDiskArray file;
    protected PageHeader header;
    private final boolean existed;

    public OnDiskArrayPageFile(int pageSize, Path filename) {
        super(pageSize);
        this.filename = filename;
        this.existed = Files.exists(filename, new LinkOption[0]);
    }

    public P readPage(int pageID) {
        try {
            this.countRead();
            return this.byteBufferToPage(this.file.getRecordBuffer(pageID));
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred during reading of page " + pageID, e);
        }
    }

    public void deletePage(int pageID) {
        try {
            super.deletePage(pageID);
            this.countWrite();
            byte[] array = this.pageToByteArray(null);
            this.file.getRecordBuffer(pageID).put(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writePage(int pageID, P page) {
        if (page.isDirty()) {
            try {
                this.countWrite();
                byte[] array = this.pageToByteArray(page);
                this.file.getRecordBuffer(pageID).put(array);
                page.setDirty(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void close() {
        try {
            super.close();
            this.file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        try {
            this.file.resizeFile(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private P byteBufferToPage(ByteBuffer buffer) {
        try (ByteBufferInputStream bais = new ByteBufferInputStream(buffer);
             ObjectInputStream ois = new ObjectInputStream((InputStream)bais);){
            int type = ois.readInt();
            if (type == 0) {
                P p = null;
                return p;
            }
            if (type != 1) throw new IllegalArgumentException("Unknown type: " + type);
            Page page = (Page)ois.readObject();
            return (P)page;
        }
        catch (IOException | ClassNotFoundException e) {
            LoggingUtil.exception((Throwable)e);
            return null;
        }
    }

    private byte[] pageToByteArray(P page) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            if (page == null) {
                oos.writeInt(0);
            } else {
                oos.writeInt(1);
                oos.writeObject(page);
            }
            oos.close();
            baos.close();
            byte[] array = baos.toByteArray();
            if (array.length > this.pageSize) {
                throw new IllegalArgumentException("Size of page " + page + " is greater than specified pagesize: " + array.length + " > " + this.pageSize);
            }
            return array.length == this.pageSize ? array : Arrays.copyOf(array, this.pageSize);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred! ", e);
        }
    }

    public boolean initialize(PageHeader header) {
        this.header = header;
        try {
            if (this.existed) {
                LOG.info((CharSequence)"Create from existing file.");
                this.file = new OnDiskArray(this.filename, 0, header.size(), this.pageSize, true);
                header.readHeader(this.file.getExtraHeader());
                for (int i = 0; i < this.file.getNumRecords(); ++i) {
                    ByteBuffer buffer = this.file.getRecordBuffer(i);
                    int type = buffer.getInt();
                    if (type == 0) {
                        this.emptyPages.add(i);
                    } else if (type == 1) {
                        this.nextPageID = i + 1;
                    } else {
                        throw new IllegalArgumentException("Unknown type: " + type);
                    }
                    ++i;
                }
                return true;
            }
            LOG.info((CharSequence)"Create a new file.");
            this.file = new OnDiskArray(this.filename, 0, header.size(), this.pageSize, 0);
            header.writeHeader(this.file.getExtraHeader());
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred.", e);
        }
    }

    protected Logging getLogger() {
        return LOG;
    }
}

