/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.persistent.AbstractPageFileFactory;
import elki.persistent.OnDiskArrayPageFile;
import elki.persistent.Page;
import elki.persistent.PageFile;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import java.nio.file.Path;
import java.nio.file.Paths;

public class OnDiskArrayPageFileFactory<P extends Page>
extends AbstractPageFileFactory<P> {
    private Path fileName;

    public OnDiskArrayPageFileFactory(int pageSize, Path fileName) {
        super(pageSize);
        this.fileName = fileName;
    }

    public PageFile<P> newPageFile(Class<P> cls) {
        if (this.fileName == null) {
            throw new AbortException("Disk-backed page file may only be instantiated once!");
        }
        OnDiskArrayPageFile pfile = new OnDiskArrayPageFile(this.pageSize, this.fileName);
        this.fileName = null;
        return pfile;
    }

    public static class Par
    extends AbstractPageFileFactory.Par<Page> {
        private Path fileName;
        public static final OptionID FILE_ID = new OptionID("pagefile.file", "The name of the file storing the page file.");

        public void configure(Parameterization config) {
            super.configure(config);
            new FileParameter(FILE_ID, FileParameter.FileType.OUTPUT_FILE).grab(config, x -> {
                this.fileName = Paths.get(x);
            });
        }

        public OnDiskArrayPageFileFactory<Page> make() {
            return new OnDiskArrayPageFileFactory<Page>(this.pageSize, this.fileName);
        }
    }
}

